/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.reactioncommands;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;

@Mod.EventBusSubscriber(modid="kingdomkeys")
public class ReactionMagic
extends ReactionCommand {
    String magic;

    public ReactionMagic(String registryName) {
        super(registryName, false);
        this.magic = registryName;
    }

    public String getMagicName() {
        return this.magic;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTranslationKey() {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)Minecraft.m_91087_().f_91074_);
        int level = playerData.getMagicLevel(new ResourceLocation(this.magic));
        Magic mag = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(this.getMagicName()));
        ++level;
        if (mag.getGMAbility() != null && playerData.getNumberOfAbilitiesEquipped(mag.getGMAbility().getRegistryName().toString()) > 0) {
            level = mag.getMaxLevel() + 1;
        }
        return "magic." + this.magic.replace(":", ".") + level + ".name";
    }

    @Override
    public void onUse(Player player, LivingEntity target, LivingEntity lockedOnEntity) {
        Magic mag = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(this.getMagicName()));
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        int level = playerData.getMagicLevel(new ResourceLocation(this.getMagicName()));
        ++level;
        if (mag.getGMAbility() != null && playerData.getNumberOfAbilitiesEquipped(mag.getGMAbility().getRegistryName().toString()) > 0) {
            level = mag.getMaxLevel() + 1;
        }
        mag.onUse(player, player, level, lockedOnEntity);
        playerData.removeReactionCommand(this.getRegistryName().toString());
    }

    @Override
    public boolean conditionsToAppear(Player player, LivingEntity target) {
        return true;
    }
}

