/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.shop;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopItem;

public class ShopList
implements INBTSerializable<CompoundTag> {
    List<ShopItem> list = new LinkedList<ShopItem>();
    @Nullable
    ResourceLocation names = null;
    ResourceLocation registryName;

    public ShopList() {
    }

    public ShopList(ResourceLocation rl, List<ShopItem> list, @Nullable List<String> names) {
        this.registryName = rl;
        this.list = list;
    }

    public void setNames(@Nullable ResourceLocation names) {
        this.names = names;
    }

    public ResourceLocation getNames() {
        return this.names;
    }

    public List<ShopItem> getList() {
        return this.list;
    }

    public void setList(List<ShopItem> list) {
        this.list = list;
    }

    public void addToList(ShopItem shopItem) {
        this.list.add(shopItem);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("regname", this.getRegistryName().toString());
        nbt.m_128405_("len", this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            ShopItem shopItem = this.list.get(i);
            nbt.m_128365_("shop_item_" + i, (Tag)shopItem.serializeNBT());
        }
        if (this.names != null) {
            nbt.m_128359_("names", this.names.toString());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.list.clear();
        for (int i = 0; i < nbt.m_128451_("len"); ++i) {
            ShopItem shopItem = new ShopItem();
            shopItem.deserializeNBT(nbt.m_128469_("shop_item_" + i));
            this.list.add(shopItem);
        }
        this.setRegistryName(nbt.m_128461_("regname"));
        if (nbt.m_128441_("names")) {
            this.setNames(new ResourceLocation(nbt.m_128461_("names")));
        }
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = new ResourceLocation(registryName);
    }

    public void setRegistryName(String namespace, String path) {
        this.registryName = new ResourceLocation(namespace, path);
    }

    public void setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
    }
}

