/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world;

import com.mojang.datafixers.util.Pair;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;

public class SavePointStorage
extends SavedData {
    private final Map<UUID, SavePoint> savePointRegistry = new HashMap<UUID, SavePoint>();

    public Map<UUID, SavePoint> getAllSavePoints() {
        return this.savePointRegistry;
    }

    public Map<UUID, SavePoint> getGlobalSavePoints() {
        return this.savePointRegistry.entrySet().stream().filter(uuidSavePointEntry -> ((SavePoint)uuidSavePointEntry.getValue()).global()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<UUID, Pair<SavePoint, Instant>> getDiscoveredSavePoints(Player player) {
        HashMap<UUID, Pair<SavePoint, Instant>> filteredRegistry = new HashMap<UUID, Pair<SavePoint, Instant>>();
        Map<UUID, Instant> uuids = ModCapabilities.getPlayer(player).discoveredSavePoints().entrySet().stream().filter(uuidInstantEntry -> this.savePointRegistry.containsKey(uuidInstantEntry.getKey()) && !this.savePointRegistry.get(uuidInstantEntry.getKey()).global).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ModCapabilities.getPlayer(player).setDiscoveredSavePoints(uuids);
        List<SavePoint> savePointList = this.savePointRegistry.entrySet().stream().filter(uuidSavePointEntry -> uuids.containsKey(uuidSavePointEntry.getKey())).map(Map.Entry::getValue).toList();
        savePointList.forEach(savePoint -> filteredRegistry.put(savePoint.id, Pair.of((Object)savePoint, (Object)((Instant)uuids.get(savePoint.id)))));
        this.getGlobalSavePoints().forEach((uuid, savePoint) -> filteredRegistry.put((UUID)uuid, (Pair<SavePoint, Instant>)Pair.of((Object)savePoint, (Object)savePoint.timeCreated)));
        return filteredRegistry;
    }

    public void addSavePoint(SavePoint savePoint) {
        this.savePointRegistry.put(savePoint.id, savePoint);
        this.m_77762_();
    }

    public void removeSavePoint(UUID id) {
        if (this.savePointRegistered(id)) {
            this.savePointRegistry.remove(id);
            this.m_77762_();
        }
    }

    public SavePoint getSavePoint(UUID id) {
        return this.savePointRegistry.get(id);
    }

    public boolean savePointRegistered(UUID id) {
        return this.savePointRegistry.containsKey(id);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        for (SavePoint savePoint : this.savePointRegistry.values()) {
            nbt.m_128365_(savePoint.id.toString(), (Tag)savePoint.serializeNBT());
        }
        return nbt;
    }

    private static SavePointStorage load(CompoundTag nbt) {
        SavePointStorage data = SavePointStorage.create();
        for (String key : nbt.m_128431_()) {
            data.addSavePoint(new SavePoint(nbt.m_128469_(key)));
        }
        return data;
    }

    private static SavePointStorage create() {
        return new SavePointStorage();
    }

    public static SavePointStorage getStorage(MinecraftServer server) {
        return (SavePointStorage)server.m_129783_().m_8895_().m_164861_(SavePointStorage::load, SavePointStorage::create, "kingdomkeys_savepoints");
    }

    public record SavePoint(UUID id, SavePointType type, String name, BlockPos pos, Pair<UUID, String> owner, ResourceKey<Level> dimension, boolean global, Instant timeCreated) {
        public SavePoint(CompoundTag nbt) {
            this(nbt.m_128342_("ID"), SavePointType.values()[nbt.m_128451_("TYPE")], nbt.m_128461_("NAME"), new BlockPos(nbt.m_128451_("POSX"), nbt.m_128451_("POSY"), nbt.m_128451_("POSZ")), (Pair<UUID, String>)Pair.of((Object)nbt.m_128342_("OWNER_UUID"), (Object)nbt.m_128461_("OWNER_NAME")), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("DIM"))), nbt.m_128471_("GLOBAL"), SavePoint.getCreatedTime(nbt));
        }

        private static Instant getCreatedTime(CompoundTag nbt) {
            if (nbt.m_128441_("TIME_EPOCH") && nbt.m_128441_("TIME_NANO")) {
                return Instant.ofEpochSecond(nbt.m_128454_("TIME_EPOCH"), nbt.m_128451_("TIME_NANO"));
            }
            return Instant.now();
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_("ID", this.id);
            nbt.m_128405_("TYPE", this.type.ordinal());
            nbt.m_128359_("NAME", this.name);
            nbt.m_128405_("POSX", this.pos.m_123341_());
            nbt.m_128405_("POSY", this.pos.m_123342_());
            nbt.m_128405_("POSZ", this.pos.m_123343_());
            nbt.m_128362_("OWNER_UUID", (UUID)this.owner.getFirst());
            nbt.m_128359_("OWNER_NAME", (String)this.owner.getSecond());
            nbt.m_128359_("DIM", this.dimension.m_135782_().toString());
            nbt.m_128379_("GLOBAL", this.global);
            nbt.m_128356_("TIME_EPOCH", this.timeCreated.getEpochSecond());
            nbt.m_128405_("TIME_NANO", this.timeCreated.getNano());
            return nbt;
        }
    }

    public static enum SavePointType implements StringRepresentable
    {
        NORMAL,
        LINKED,
        WARP;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

