/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.CardDoorBlock;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.CastleOblivionCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorCapability;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateCORooms;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.DynamicDimensionManager;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionInteriorChunkGenerator;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.CastleOblivionEvent;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomGenerator;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class CastleOblivionHandler {
    public static final ResourceKey<Level> CASTLE_OBLIVION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("kingdomkeys", "castle_oblivion"));
    public static final Utils.BlockPosBounds entranceBounds = new Utils.BlockPosBounds(-10, 87, 11, -1, 100, 11);
    public static final Utils.BlockPosBounds firstDoorBounds = new Utils.BlockPosBounds(15, 63, 67, 17, 66, 67);
    public static final BlockPos entrancePos = new BlockPos(16, 62, 2);
    public static final BlockPos exitPos = new BlockPos(-5, 90, 6);

    @SubscribeEvent
    public void tick(TickEvent.LevelTickEvent event) {
        CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap;
        if (CastleOblivionHandler.isInterior((ResourceKey<Level>)event.level.m_46472_()) && (cap = ModCapabilities.getCastleOblivionInterior(event.level)) != null) {
            cap.getFloors().forEach(floor -> {
                if (floor.shouldTick()) {
                    floor.getPlayers().values().forEach(room -> room.getRoomData(event.level).getGenerated().tick());
                }
            });
        }
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (CastleOblivionHandler.inInterior(event.getPlayer()) && event.getState().m_60734_() == ModBlocks.cardDoor.get() && ((Boolean)event.getState().m_61143_((Property)CardDoorBlock.GENERATED)).booleanValue()) {
            event.setCanceled(true);
        }
    }

    public static void enterCastleOblivion(Player player) {
        if (player.m_9236_().m_7654_() != null) {
            ResourceLocation dimName = new ResourceLocation("kingdomkeys", "castle_oblivion_interior_" + player.m_20149_());
            ModCapabilities.getCastleOblivionExterior(player.m_9236_()).addInterior(player.m_20148_(), dimName);
            RegistryAccess registryAccess = player.m_9236_().m_9598_();
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimName);
            Holder.Reference type = registryAccess.m_175515_(Registries.f_256787_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("kingdomkeys", "castle_oblivion")));
            Holder.Reference biome = registryAccess.m_175515_(Registries.f_256952_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("kingdomkeys", "castle_oblivion_interior")));
            ServerLevel level = DynamicDimensionManager.getOrCreateLevel(player.m_9236_().m_7654_(), (ResourceKey<Level>)dimension, (arg_0, arg_1) -> CastleOblivionHandler.lambda$enterCastleOblivion$2((Holder)biome, (Holder)type, arg_0, arg_1));
            player.changeDimension(level, (ITeleporter)new BaseTeleporter(entrancePos));
        }
    }

    public static void exitCastleOblivion(Floor currentFloor, Room currentRoom, Player player) {
        if (player.m_9236_().m_7654_() != null) {
            player.changeDimension(player.m_9236_().m_7654_().m_129880_(CASTLE_OBLIVION), (ITeleporter)new BaseTeleporter(exitPos));
            MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(currentRoom, null, player));
            MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeFloorEvent(currentFloor, null, player));
        }
    }

    public static Room createFirstRoom(Player player, CardDoorTileEntity te) {
        CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap = ModCapabilities.getCastleOblivionInterior(player.m_9236_());
        if (cap != null) {
            Floor floor = cap.getFloorByID(te.getParentRoom().getParentID());
            if (te.getParentRoom().equals(floor.getEntranceHall())) {
                if (floor.getGeneratedRooms().size() == 1) {
                    te.setDestinationRoom(floor.getRoom(new RoomPos(0, 1)));
                    for (Player playerFromList : player.m_9236_().m_6907_()) {
                        PacketHandler.sendTo(new SCUpdateCORooms(floor.getRooms()), (ServerPlayer)playerFromList);
                    }
                    return RoomGenerator.INSTANCE.generateRoom(player.m_9236_(), floor.getRoom(new RoomPos(0, 1)), ModRoomTypes.SLEEPING_DARKNESS.get(), te.getParentRoom().getGenerated(), RoomDirection.NORTH);
                }
                return floor.getRoom(new RoomPos(0, 1)).getGenerated();
            }
        }
        return null;
    }

    public static void enterFirstRoom(Player player) {
        CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap = ModCapabilities.getCastleOblivionInterior(player.m_9236_());
        if (cap != null) {
            Room currentRoom = cap.getRoomAtPos(player.m_9236_(), player.m_20183_());
            Floor floor = cap.getFloorByID(currentRoom.parentFloor);
            if (!currentRoom.getType().isEntranceHall()) {
                KingdomKeys.LOGGER.info("something is wrong player should be in the entrance hall room");
            } else if (floor.getGeneratedRooms().size() > 1) {
                Room firstRoom = floor.getRoom(new RoomPos(0, 1)).getGenerated();
                BlockPos newPos = firstRoom.doors.get((Object)RoomDirection.NORTH).pos();
                CardDoorTileEntity te = (CardDoorTileEntity)player.m_9236_().m_7702_(newPos);
                if (te != null && !MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(currentRoom, firstRoom, player))) {
                    newPos = newPos.m_121955_(te.getDirection().toMCDirection().m_122436_().m_142393_(2));
                    te.openDoor(true);
                    player.m_6021_((double)newPos.m_123341_(), (double)newPos.m_123342_(), (double)newPos.m_123343_());
                    PacketHandler.sendTo(new SCSyncCastleOblivionInteriorCapability(ModCapabilities.getCastleOblivionInterior(player.m_9236_())), (ServerPlayer)player);
                }
            }
        }
    }

    public static boolean isExterior(ResourceKey<Level> level) {
        return level.equals(CASTLE_OBLIVION);
    }

    public static boolean isInterior(ResourceKey<Level> level) {
        return level.m_135782_().toString().contains("castle_oblivion_interior_");
    }

    public static boolean inExterior(Player player) {
        return CastleOblivionHandler.isExterior((ResourceKey<Level>)player.m_9236_().m_46472_());
    }

    public static boolean inInterior(Player player) {
        return CastleOblivionHandler.isInterior((ResourceKey<Level>)player.m_9236_().m_46472_());
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_9236_().f_46443_ && CastleOblivionHandler.inExterior(event.player) && Utils.isPlayerWithin(event.player, entranceBounds)) {
            CastleOblivionHandler.enterCastleOblivion(event.player);
        }
    }

    @SubscribeEvent
    public void changeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (CastleOblivionHandler.isExterior((ResourceKey<Level>)event.getFrom())) {
            if (CastleOblivionHandler.isInterior((ResourceKey<Level>)event.getTo())) {
                SCSyncCastleOblivionInteriorCapability.syncClients(event.getEntity().m_9236_());
                event.getEntity().m_213846_((Component)Component.m_237115_((String)"I REPEAT, CASTLE OBLIVION IS WORK IN PROGRESS DON'T REPORT ANY ISSUES WITH IT YET PLEASE"));
                event.getEntity().m_213846_((Component)Component.m_237115_((String)"IF YOUR GAME CRASHES HERE IT'S EXPECTED, THE OUTSIDE PART IS PROBABLY SAFE FROM CRASHES BUT NOT HERE DEFINITELY NOT HERE"));
                event.getEntity().m_213846_((Component)Component.m_237115_((String)"THANK YOU AGAIN - Estelle"));
                ServerLevel level = event.getEntity().m_9236_().m_7654_().m_129880_(event.getTo());
                Floor startFloor = Floor.getOrCreateFirstFloor((Level)level);
                MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeFloorEvent(null, startFloor, event.getEntity()));
                PacketHandler.sendTo(new SCUpdateCORooms(CastleOblivionHandler.getCurrentFloor(event.getEntity()).getRooms()), (ServerPlayer)event.getEntity());
                startFloor.floorEntered(event.getEntity());
            }
        } else {
            PacketHandler.sendTo(new SCUpdateCORooms(List.of()), (ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void joinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (CastleOblivionHandler.inInterior(event.getEntity())) {
            PacketHandler.sendTo(new SCSyncCastleOblivionInteriorCapability(ModCapabilities.getCastleOblivionInterior(event.getEntity().m_9236_())), (ServerPlayer)event.getEntity());
        }
    }

    public static Floor getCurrentFloor(Player player) {
        return ModCapabilities.getCastleOblivionInterior(player.m_9236_()).getFloorAtPos(player.m_9236_(), player.m_20183_());
    }

    @SubscribeEvent
    public void changedRoom(CastleOblivionEvent.PlayerChangeRoomEvent event) {
        if (event.getNewRoom() != null) {
            System.out.println("Entered Room: " + String.valueOf(event.getNewRoom().getPosition()));
        }
    }

    @SubscribeEvent
    public void generatedRoom(CastleOblivionEvent.RoomGeneratedEvent event) {
        if (event.getGeneratedRoomData() != null) {
            System.out.println("Generated a new room: " + String.valueOf(event.getGeneratedRoomData().getGenerated()));
        }
    }

    private static /* synthetic */ LevelStem lambda$enterCastleOblivion$2(Holder biome, Holder type, MinecraftServer minecraftServer, ResourceKey levelStemResourceKey) {
        CastleOblivionInteriorChunkGenerator generator = new CastleOblivionInteriorChunkGenerator((BiomeSource)new FixedBiomeSource(biome));
        return new LevelStem(type, (ChunkGenerator)generator);
    }
}

