/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;

public class RoomData
implements INBTSerializable<CompoundTag> {
    Map<RoomDirection, DoorData> doors;
    public final RoomPos pos;
    int parent;
    Room generatedRoom;
    Type type;
    int cardCost;

    public RoomData(RoomPos pos, Type type) {
        this(pos);
        this.type = type;
    }

    public RoomData(RoomPos pos) {
        this.pos = pos;
        this.doors = new HashMap<RoomDirection, DoorData>();
        this.cardCost = Utils.randomWithRange(0, 9);
    }

    public RoomData(CompoundTag tag) {
        this(new RoomPos(tag.m_128469_("roompos")));
        this.deserializeNBT(tag);
    }

    public Type getType() {
        return this.type;
    }

    public void finalizeType(Type type) {
        if (this.type == null) {
            this.type = type;
        }
    }

    public int getParentID() {
        return this.parent;
    }

    public Floor getParentFloor(Level level) {
        return ModCapabilities.getCastleOblivionInterior(level).getFloorByID(this.parent);
    }

    public void setParent(Floor parent) {
        this.parent = parent.getFloorID();
    }

    public void addDoor(DoorData.Type doorType, RoomDirection direction) {
        if (!this.doors.containsKey((Object)direction)) {
            this.setDoor(doorType, direction);
        }
    }

    public void setDoor(DoorData.Type doorType, RoomDirection direction) {
        this.doors.put(direction, new DoorData(this, doorType, direction));
    }

    public void setRemainingDoors(DoorData.Type doorType) {
        for (RoomDirection dir : RoomDirection.values()) {
            if (this.doors.containsKey((Object)dir)) continue;
            this.doors.put(dir, new DoorData(this, doorType, dir));
        }
    }

    public DoorData getDoor(RoomDirection direction) {
        return this.doors.get((Object)direction);
    }

    public Map<RoomDirection, DoorData> getDoors() {
        return this.doors;
    }

    public int getCardCost() {
        return this.cardCost;
    }

    public void setGenerated(Room room) {
        this.generatedRoom = room;
    }

    public Room getGenerated() {
        return this.generatedRoom;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("parent", this.parent);
        tag.m_128405_("door_count", this.doors.size());
        CompoundTag doorDataTag = new CompoundTag();
        int i = 0;
        for (Map.Entry<RoomDirection, DoorData> doorPair : this.doors.entrySet()) {
            doorDataTag.m_128405_("door_direction_" + i, doorPair.getKey().ordinal());
            doorDataTag.m_128365_("door_data_" + i, (Tag)doorPair.getValue().serializeNBT());
            ++i;
        }
        tag.m_128365_("doors", (Tag)doorDataTag);
        tag.m_128365_("roompos", (Tag)this.pos.serializeNBT());
        tag.m_128379_("generated", this.generatedRoom != null);
        if (this.generatedRoom != null) {
            tag.m_128365_("generated_room", (Tag)this.generatedRoom.serializeNBT());
        }
        tag.m_128405_("card_cost", this.cardCost);
        if (this.type != null) {
            tag.m_128405_("type", this.type.ordinal());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.parent = tag.m_128451_("parent");
        int doorCount = tag.m_128451_("door_count");
        this.doors.clear();
        CompoundTag doorDataTag = tag.m_128469_("doors");
        for (int i = 0; i < doorCount; ++i) {
            int dir = doorDataTag.m_128451_("door_direction_" + i);
            this.doors.put(RoomDirection.values()[dir], new DoorData(doorDataTag.m_128469_("door_data_" + i)));
        }
        if (tag.m_128471_("generated")) {
            this.generatedRoom = new Room(tag.m_128469_("generated_room"));
        }
        this.cardCost = tag.m_128451_("card_cost");
        if (tag.m_128441_("type")) {
            this.type = Type.values()[tag.m_128451_("type")];
        }
    }

    public static enum Type {
        ENTRANCE,
        EXIT,
        BOSS,
        NORMAL;

    }
}

