/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.deathlyhallows.common.properties;

import com.emoniph.witchery.util.EntityUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPlayer
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "DeathlyHallows";
    private final EntityPlayer player;
    private int currentDuration;
    private EntityPlayer source;
    private double x;
    private double y;
    private double z;
    private int dimension;
    private int elfLvl;
    private int trigger;
    private int elfCount;
    private int mobsKilled;
    private int spellsUsed;
    private int foodEaten;
    private boolean choice;
    private int mobsFed;
    private boolean damageLog;
    private String monsters = "";
    private List foodCollection = new ArrayList();
    Multimap<String, AttributeModifier> attributes = HashMultimap.create();
    public float hpPerLvl = 4.0f;

    public ExtendedPlayer(EntityPlayer player) {
        this.player = player;
    }

    public void init(Entity entity, World world) {
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ExtendedPlayer(player));
    }

    public static final ExtendedPlayer get(EntityPlayer player) {
        return (ExtendedPlayer)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("CurrentDuration", this.currentDuration);
        properties.func_74780_a("X", this.x);
        properties.func_74780_a("Y", this.y);
        properties.func_74780_a("Z", this.z);
        properties.func_74768_a("Dimension", this.dimension);
        properties.func_74768_a("ElfLvl", this.elfLvl);
        properties.func_74768_a("Trigger", this.trigger);
        properties.func_74768_a("ElfCount", this.elfCount);
        properties.func_74768_a("MobsKilled", this.mobsKilled);
        properties.func_74768_a("SpellsUsed", this.spellsUsed);
        properties.func_74768_a("FoodEaten", this.foodEaten);
        properties.func_74757_a("Choice", this.choice);
        properties.func_74768_a("MobsFed", this.mobsFed);
        properties.func_74778_a("DHMonsters", this.monsters);
        properties.func_74757_a("Logs", this.damageLog);
        for (int i = 0; i < this.foodCollection.size(); ++i) {
            properties.func_74778_a("DHFood" + i, this.foodCollection.get(i).toString());
            properties.func_74768_a("DHFoodSize", i);
        }
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b(EXT_PROP_NAME)) {
            NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
            this.currentDuration = properties.func_74762_e("CurrentDuration");
            this.x = properties.func_74769_h("X");
            this.y = properties.func_74769_h("Y");
            this.z = properties.func_74769_h("Z");
            this.dimension = properties.func_74762_e("Dimension");
            this.elfLvl = properties.func_74762_e("ElfLvl");
            this.trigger = properties.func_74762_e("Trigger");
            this.elfCount = properties.func_74762_e("ElfCount");
            this.mobsKilled = properties.func_74762_e("MobsKilled");
            this.spellsUsed = properties.func_74762_e("SpellsUsed");
            this.foodEaten = properties.func_74762_e("FoodEaten");
            this.choice = properties.func_74767_n("Choice");
            this.mobsFed = properties.func_74762_e("MobsFed");
            this.damageLog = properties.func_74767_n("Logs");
            this.monsters = properties.func_74779_i("DHMonsters");
            for (int i = 0; i < properties.func_74762_e("DHFoodSize"); ++i) {
                this.foodCollection.add(i, properties.func_74779_i("DHFood" + i));
            }
        }
    }

    public void setAllNull() {
        this.trigger = 0;
        this.elfCount = 0;
        this.mobsKilled = 0;
        this.spellsUsed = 0;
        this.foodEaten = 0;
        this.foodCollection.clear();
    }

    public void sync() {
    }

    public List getFoodCollection() {
        return this.foodCollection;
    }

    public void addFoodToCollection(String name) {
        for (int i = 0; i < this.foodCollection.size(); ++i) {
            if (!this.foodCollection.get(i).toString().equals(name)) continue;
            return;
        }
        this.foodCollection.add(name);
    }

    public void deadInside(EntityLivingBase target) {
        if (target instanceof EntityPlayer) {
            EntityPlayer playerTarget = (EntityPlayer)target;
            if (playerTarget.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        if (this.source != null) {
            EntityUtil.instantDeath((EntityLivingBase)target, (EntityLivingBase)this.source);
        } else {
            EntityUtil.instantDeath((EntityLivingBase)target, (EntityLivingBase)this.player);
        }
    }

    public boolean getDamageLog() {
        return this.damageLog;
    }

    public void setDamageLog(boolean choice2) {
        this.damageLog = choice2;
    }

    public int getMonstersCount() {
        int count = 0;
        if (this.monsters != null) {
            for (String monster : this.monsters.split(",")) {
                ++count;
            }
        }
        System.out.println(this.monsters);
        return count;
    }

    public void addMonster(String name) {
        if (!this.monsters.contains(name)) {
            this.monsters = this.monsters + name + ",";
        }
    }

    public int getMobsFed() {
        return this.mobsFed;
    }

    public void setMobsFed(int count) {
        this.mobsFed = count;
    }

    public boolean getChoice() {
        return this.choice;
    }

    public void setChoice(boolean choice1) {
        this.choice = choice1;
    }

    public int getFoodEaten() {
        return this.foodEaten;
    }

    public void setFoodEaten(int count) {
        this.foodEaten = count;
    }

    public int getMobsKilled() {
        return this.mobsKilled;
    }

    public void setMobsKilled(int count) {
        this.mobsKilled = count;
    }

    public int getSpellsUsed() {
        return this.spellsUsed;
    }

    public void setSpellsUsed(int count) {
        this.spellsUsed = count;
    }

    public void setCurrentDuration(int duration) {
        this.currentDuration = duration;
    }

    public void setSource(EntityPlayer source) {
        this.source = source;
    }

    public void lowerDuration() {
        if (this.currentDuration > 0) {
            --this.currentDuration;
        }
    }

    public int getCurrentDuration() {
        return this.currentDuration;
    }

    public EntityPlayer getSource() {
        return this.source;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setCoordinates(double x, double y, double z, int dimention) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimention;
    }

    public int getElfLvl() {
        return this.elfLvl;
    }

    public void increaseElfLvl() {
        ++this.elfLvl;
        this.attributes.clear();
        this.attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("DH HP", (double)this.hpPerLvl, 0));
        this.player.func_110140_aT().func_111147_b(this.attributes);
    }

    public void maxElfLvl() {
        this.attributes.clear();
        this.attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("DH HP", (double)(this.hpPerLvl * 10.0f), 0));
        this.player.func_110140_aT().func_111147_b(this.attributes);
        this.elfLvl = 10;
    }

    public void decreaseElfLvl() {
        --this.elfLvl;
        this.attributes.clear();
        this.attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("DH HP", (double)(-this.hpPerLvl), 0));
        this.player.func_110140_aT().func_111147_b(this.attributes);
    }

    public void nullifyElfLvl() {
        this.attributes.clear();
        this.attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("DH HP", (double)((float)(-this.elfLvl) * this.hpPerLvl), 0));
        this.player.func_110140_aT().func_111147_b(this.attributes);
        this.elfLvl = 0;
        this.setAllNull();
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int number) {
        this.trigger = number;
    }

    public int getElfCount() {
        return this.elfCount;
    }

    public void setElfCount(int number) {
        this.elfCount = number;
    }
}

