/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.deathlyhallows.spells;

import com.emoniph.witchery.blocks.BlockAltar;
import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.common.IPowerSource;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.ritual.Rite;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.pyding.deathlyhallows.common.properties.ExtendedPlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class RiteOfElvenVanishing
extends Rite {
    private final float upkeepPowerCost;
    private final int ticksToLive;
    private final int radius;

    public RiteOfElvenVanishing(int radius, float upkeepPowerCost, int ticksToLive) {
        this.radius = radius;
        this.upkeepPowerCost = upkeepPowerCost;
        this.ticksToLive = ticksToLive;
    }

    public void addSteps(ArrayList<RitualStep> steps, int intialStage) {
        steps.add(new StepVanish(this, intialStage));
    }

    private static class StepVanish
    extends RitualStep {
        private final RiteOfElvenVanishing rite;
        private boolean activated = false;
        protected int ticksSoFar;
        Coord powerSourceCoord;
        static final int POWER_SOURCE_RADIUS = 16;

        public StepVanish(RiteOfElvenVanishing rite, int ticksSoFar) {
            super(false);
            this.rite = rite;
            this.ticksSoFar = ticksSoFar;
        }

        public int getCurrentStage() {
            return this.ticksSoFar;
        }

        public RitualStep.Result process(World world, int posX, int posY, int posZ, long ticks, BlockCircle.TileEntityCircle.ActivatedRitual ritual) {
            if (ticks % 20L != 0L) {
                return RitualStep.Result.STARTING;
            }
            if (!world.field_72995_K) {
                if (this.rite.upkeepPowerCost > 0.0f) {
                    IPowerSource powerSource = this.getPowerSource(world, posX, posY, posZ);
                    if (powerSource == null) {
                        return RitualStep.Result.ABORTED;
                    }
                    this.powerSourceCoord = powerSource.getLocation();
                    if (!powerSource.consumePower(this.rite.upkeepPowerCost)) {
                        return RitualStep.Result.ABORTED;
                    }
                }
                if (this.rite.ticksToLive > 0 && ticks % 20L == 0L && ++this.ticksSoFar >= this.rite.ticksToLive) {
                    return RitualStep.Result.COMPLETED;
                }
                int r = this.rite.radius;
                AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(posX - r), (double)posY, (double)(posZ - r), (double)(posX + r), (double)(posY + 1), (double)(posZ + r));
                for (Object obj : world.func_72872_a(EntityPlayer.class, bounds)) {
                    ExtendedPlayer props;
                    EntityPlayer player = (EntityPlayer)obj;
                    if (!(Coord.distance((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)posX, (double)posY, (double)posZ) <= (double)r) || (props = ExtendedPlayer.get(player)).getElfLvl() <= 0) continue;
                    props.nullifyElfLvl();
                    ParticleEffect.INSTANT_SPELL.send(SoundEffect.NOTE_PLING, (Entity)player, 1.0, 2.0, 8);
                    ParticleEffect.INSTANT_SPELL.send(SoundEffect.RANDOM_LEVELUP, (Entity)player, 1.0, 2.0, 8);
                    return RitualStep.Result.COMPLETED;
                }
            }
            return RitualStep.Result.UPKEEP;
        }

        IPowerSource getPowerSource(World world, int posX, int posY, int posZ) {
            if (this.powerSourceCoord != null && world.field_73012_v.nextInt(5) != 0) {
                TileEntity tileEntity = this.powerSourceCoord.getBlockTileEntity(world);
                if (!(tileEntity instanceof BlockAltar.TileEntityAltar)) {
                    return this.findNewPowerSource(world, posX, posY, posZ);
                }
                BlockAltar.TileEntityAltar altarTileEntity = (BlockAltar.TileEntityAltar)tileEntity;
                return !altarTileEntity.isValid() ? this.findNewPowerSource(world, posX, posY, posZ) : altarTileEntity;
            }
            return this.findNewPowerSource(world, posX, posY, posZ);
        }

        private IPowerSource findNewPowerSource(World world, int posX, int posY, int posZ) {
            List sources = PowerSources.instance() != null ? PowerSources.instance().get(world, new Coord(posX, posY, posZ), 16) : null;
            return sources != null && sources.size() > 0 ? ((PowerSources.RelativePowerSource)sources.get(0)).source() : null;
        }
    }
}

