/*
 * Decompiled with CFR 0.152.
 */
package com.dimaskama.donthitteammates.client.config;

import com.dimaskama.donthitteammates.client.DHTMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;

public abstract class Config {
    private final transient String CONFPATH;

    public Config(String path) {
        this.CONFPATH = path;
    }

    public void loadOrCreate() {
        File file = new File(this.CONFPATH);
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                DHTMod.LOGGER.warn("Can't create config: " + parent.getAbsolutePath());
            }
            try {
                this.saveJsonWithoutCatch();
            }
            catch (IOException e) {
                DHTMod.LOGGER.warn("Exception occurred while writing new config. " + e);
            }
        } else {
            try (FileReader f = new FileReader(this.CONFPATH);){
                Config c = (Config)new Gson().fromJson((Reader)f, this.getClass());
                for (Field field : this.getClass().getDeclaredFields()) {
                    field.set(this, field.get(c));
                }
            }
            catch (IOException | IllegalAccessException e) {
                DHTMod.LOGGER.warn("Exception occurred while reading config. " + e);
            }
        }
    }

    public void saveJson() {
        try {
            this.saveJsonWithoutCatch();
        }
        catch (IOException e) {
            DHTMod.LOGGER.warn("Exception occurred while saving config. " + e);
        }
    }

    public void saveJsonWithoutCatch() throws IOException {
        try (FileWriter w = new FileWriter(this.CONFPATH);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, (Appendable)w);
            DHTMod.LOGGER.info("Config saved: " + this.CONFPATH);
        }
    }

    public void reset() {
        try {
            Config n = (Config)this.getClass().getConstructor(String.class).newInstance(this.CONFPATH);
            for (Field field : this.getClass().getDeclaredFields()) {
                field.set(this, field.get(n));
            }
        }
        catch (Exception e) {
            DHTMod.LOGGER.warn("Exception occurred while resetting config. " + e);
        }
    }
}

