/*
 * Decompiled with CFR 0.152.
 */
package com.dimaskama.donthitteammates.client.screen;

import com.dimaskama.donthitteammates.client.DHTMod;
import com.dimaskama.donthitteammates.client.config.Teammate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_742;
import net.minecraft.class_746;

public class DHTScreen
extends class_437 {
    public static final class_2561 X_TEXT = class_2561.method_43470((String)"X");
    public static final class_2561 INPUT_PLACEHOLDER = class_2561.method_43471((String)"text.donthitteammates.nickname_input").method_27694(style -> style.method_36139(0x777777));
    public static final class_2561 BLANK_NICKNAME_ERROR = class_2561.method_43471((String)"error.donthitteammates.blank_nickname");
    public static final class_2561 ALREADY_IN_LIST_ERROR = class_2561.method_43471((String)"error.donthitteammates.already_in_list");
    public static final class_2960 UNKNOWN_PLAYER_TEXTURE = new class_2960("donthitteammates", "textures/gui/unknown_player.png");
    public static final class_2960 ACCEPT_BUTTON = new class_2960("donthitteammates", "textures/gui/accept_button.png");
    private final class_437 parent;
    private TeammatesListWidget listWidget;
    private class_342 inputField;
    private class_2960 inputTexture = UNKNOWN_PLAYER_TEXTURE;
    private boolean firstInit = true;
    private class_2561 errorText;
    private int errorTextTime;

    public DHTScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"donthitteammates"));
        this.parent = parent;
    }

    protected void method_25426() {
        if (this.firstInit) {
            this.firstInit = false;
            this.listWidget = new TeammatesListWidget(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 64, 40, DHTMod.CONFIG.teammates);
            this.method_25429((class_364)this.listWidget);
            this.inputField = new class_342(class_310.method_1551().field_1772, this.field_22789 - 120 >> 1, this.field_22790 - 56, 120, 20, (class_2561)class_2561.method_43473());
            this.inputField.method_47404(INPUT_PLACEHOLDER);
            this.inputField.method_1863(string -> {
                if (!string.isEmpty()) {
                    if (string.endsWith(" ")) {
                        this.inputField.method_1852(string.replaceAll(" ", ""));
                        this.addTeammate();
                        return;
                    }
                    class_742 player = DHTScreen.findMatchingPlayer(string);
                    this.inputTexture = player != null ? player.method_3117() : UNKNOWN_PLAYER_TEXTURE;
                } else {
                    this.inputTexture = UNKNOWN_PLAYER_TEXTURE;
                }
            });
            this.method_37063((class_364)this.inputField);
        } else {
            this.inputField.method_48229(this.field_22789 - 120 >> 1, this.field_22790 - 56);
            this.listWidget.method_25323(this.field_22789, this.field_22790, 32, this.field_22790 - 64);
        }
        this.method_37063((class_364)new class_344((this.field_22789 + 120 >> 1) + 3, this.field_22790 - 57, 22, 22, 0, 0, 22, ACCEPT_BUTTON, 22, 44, button -> this.addTeammate()));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.method_25419()).method_46434(this.field_22789 - 120 >> 1, this.field_22790 - 28, 120, 20).method_46431());
    }

    private void addTeammate() {
        String nickname = this.inputField.method_1882();
        this.inputField.method_1852("");
        this.method_20086((class_364)this.inputField);
        if (nickname.isBlank()) {
            this.setErrorText(BLANK_NICKNAME_ERROR);
            return;
        }
        if (this.listWidget.hasNickname(nickname)) {
            this.setErrorText(ALREADY_IN_LIST_ERROR);
            return;
        }
        this.listWidget.addTeammate(new Teammate(nickname));
    }

    private void setErrorText(class_2561 errorText) {
        this.errorText = errorText;
        this.errorTextTime = 60;
    }

    public void method_25393() {
        if (this.errorTextTime > 0) {
            --this.errorTextTime;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 >> 1, 8, 0xFFFFFF);
        this.listWidget.method_25394(context, mouseX, mouseY, delta);
        int headX = (this.field_22789 - 120 >> 1) - 36;
        int headY = this.field_22790 - 56;
        context.method_25294(headX - 1, headY - 1, headX + 33, headY + 33, -1);
        context.method_25293(this.inputTexture, headX, headY, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
        if (this.errorText != null && this.errorTextTime > 0) {
            int alpha = (int)(Math.min(1.0f, ((float)this.errorTextTime - delta) / 20.0f) * 255.0f);
            int textWidth = this.field_22793.method_27525((class_5348)this.errorText);
            context.method_25294((this.field_22789 - textWidth >> 1) - 4, this.field_22790 - 84, (this.field_22789 + textWidth >> 1) + 4, this.field_22790 - 65, alpha >> 1 << 24);
            context.method_27534(this.field_22793, this.errorText, this.field_22789 >> 1, this.field_22790 - 79, alpha << 24 | 0xFF9999);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        DHTMod.CONFIG.teammates = this.listWidget.getTeammatesList();
        DHTMod.CONFIG.saveJson();
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        } else {
            super.method_25419();
        }
    }

    public static class_742 findMatchingPlayer(String nickname) {
        class_1657 renderPlayer;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && (renderPlayer = (class_1657)player.method_37908().method_18456().stream().filter(p -> p.method_5820().equalsIgnoreCase(nickname)).findAny().orElse(null)) instanceof class_742) {
            class_742 p2 = (class_742)renderPlayer;
            return p2;
        }
        return null;
    }

    public static class TeammatesListWidget
    extends class_350<Entry> {
        public TeammatesListWidget(class_310 client, int width, int height, int top, int bottom, int itemHeight, List<Teammate> teammates) {
            super(client, width, height, top, bottom, itemHeight);
            for (Teammate teammate : teammates) {
                this.method_25321(new Entry(this, teammate));
            }
        }

        public void method_37020(class_6382 builder) {
        }

        public void addTeammate(Teammate teammate) {
            this.method_25321(new Entry(this, teammate));
        }

        public List<Teammate> getTeammatesList() {
            ArrayList<Teammate> teammates = new ArrayList<Teammate>();
            for (int i = 0; i < this.method_25340(); ++i) {
                teammates.add(((Entry)this.method_25326((int)i)).teammate);
            }
            return teammates;
        }

        public boolean hasNickname(String nickname) {
            for (int i = 0; i < this.method_25340(); ++i) {
                Entry entry = (Entry)this.method_25326(i);
                if (!entry.teammate.name.equalsIgnoreCase(nickname)) continue;
                return true;
            }
            return false;
        }

        public static class Entry
        extends class_350.class_351<Entry> {
            private final TeammatesListWidget list;
            private final class_2960 skinTexture;
            private final Teammate teammate;
            private final class_4185 removeButton;
            private final class_4185 hideButton;

            public Entry(TeammatesListWidget list, Teammate teammate) {
                this.list = list;
                this.teammate = teammate;
                class_742 player = DHTScreen.findMatchingPlayer(teammate.name);
                if (player != null) {
                    teammate.name = player.method_5820();
                    this.skinTexture = player.method_3117();
                } else {
                    this.skinTexture = UNKNOWN_PLAYER_TEXTURE;
                }
                this.removeButton = class_4185.method_46430((class_2561)X_TEXT, button -> this.list.method_25330(this)).method_46437(16, 16).method_46431();
                this.hideButton = class_4185.method_46430((class_2561)(teammate.enabled ? class_5244.field_24333 : class_5244.field_24332), button -> this.toggleEnabled()).method_46437(32, 16).method_46431();
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                class_327 textRenderer = class_310.method_1551().field_1772;
                context.method_25294(x + 1, y + 1, x + 35, y + 35, -1);
                context.method_25293(this.skinTexture, x + 2, y + 2, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
                String string = this.teammate.name;
                Objects.requireNonNull(textRenderer);
                context.method_25303(textRenderer, string, x + 40, y + (entryHeight - 9 >> 1), 0xFFFFFF);
                this.updatePos(x, y, entryWidth);
                this.removeButton.method_25394(context, mouseX, mouseY, tickDelta);
                this.hideButton.method_25394(context, mouseX, mouseY, tickDelta);
                if (!this.teammate.enabled) {
                    context.method_25296(x, y, x + entryWidth - 4, y + entryHeight, -2013265920, -2013265920);
                }
            }

            public void toggleEnabled() {
                this.teammate.enabled = !this.teammate.enabled;
                this.hideButton.method_25355(this.teammate.enabled ? class_5244.field_24333 : class_5244.field_24332);
            }

            public void updatePos(int x, int y, int entryWidth) {
                this.removeButton.method_46421(x + entryWidth - 26);
                this.removeButton.method_46419(y += 9);
                this.hideButton.method_46421(x + entryWidth - 62);
                this.hideButton.method_46419(y);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.removeButton.method_25405(mouseX, mouseY)) {
                    this.removeButton.method_25402(mouseX, mouseY, button);
                } else if (this.hideButton.method_25405(mouseX, mouseY)) {
                    this.hideButton.method_25402(mouseX, mouseY, button);
                } else {
                    return true;
                }
                return false;
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 261) {
                    this.list.method_25330(this);
                    return true;
                }
                if (keyCode == 259 || keyCode == 72) {
                    this.toggleEnabled();
                    return true;
                }
                return false;
            }
        }
    }
}

