/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block;

import axolootl.block.AbstractInterfaceBlock;
import axolootl.block.BlockConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class AquariumGlassBlock
extends AbstractGlassBlock {
    private static final List<BlockConverter> BLOCK_CONVERTERS = new ArrayList<BlockConverter>();
    public static final List<BlockConverter> BLOCK_CONVERTERS_VIEW = Collections.unmodifiableList(BLOCK_CONVERTERS);

    public AquariumGlassBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.m_204336_(AbstractInterfaceBlock.GLASS) || pAdjacentBlockState.m_204336_(AbstractInterfaceBlock.AQUARIUM) || super.m_6104_(pState, pAdjacentBlockState, pSide);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        Direction direction = pHit.m_82434_();
        if (!pPlayer.m_6144_()) {
            for (BlockConverter f : BLOCK_CONVERTERS) {
                Optional oState = (Optional)f.apply(itemStack);
                if (!oState.isPresent()) continue;
                BlockState state = (BlockState)oState.get();
                if (state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                    state = (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction);
                }
                this.convert(pLevel, pPos, pPlayer, pHand, itemStack, state);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private boolean convert(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack, BlockState blockState) {
        boolean result = BlockConverter.convert(level, pos, player, hand, itemStack, blockState, 3);
        return result;
    }

    public static void registerItemConverter(BlockConverter function) {
        BLOCK_CONVERTERS.add(function);
    }
}

