/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block;

import axolootl.AxRegistry;
import axolootl.block.AbstractInterfaceBlock;
import axolootl.block.entity.AxolootlInspectorBlockEntity;
import axolootl.data.aquarium_tab.IAquariumTab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class AxolootlInspectorBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public AxolootlInspectorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_});
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.m_60713_((Block)this) || pAdjacentBlockState.m_204336_(AbstractInterfaceBlock.GLASS) || pAdjacentBlockState.m_204336_(AbstractInterfaceBlock.AQUARIUM) || super.m_6104_(pState, pAdjacentBlockState, pSide);
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)AxRegistry.BlockEntityReg.AXOLOOTL_INSPECTOR.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_() || !pState.m_60713_((Block)this) || pBlockEntityType != AxRegistry.BlockEntityReg.AXOLOOTL_INSPECTOR.get()) {
            return null;
        }
        return AxolootlInspectorBlockEntity::tick;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof AxolootlInspectorBlockEntity) {
                AxolootlInspectorBlockEntity blockEntity2 = (AxolootlInspectorBlockEntity)blockEntity;
                if (blockEntity2.hasTank() && blockEntity2.validateController(pLevel)) {
                    blockEntity2.m_6596_();
                }
                if (blockEntity2.isMenuAvailable((Player)serverPlayer, blockEntity2.getController().orElse(null))) {
                    BlockPos controllerPos = blockEntity2.getController().isPresent() ? blockEntity2.getController().get().m_58899_() : pPos;
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)blockEntity2, AxRegistry.MenuReg.writeControllerMenu(controllerPos, pPos, ((IAquariumTab)AxRegistry.AquariumTabsReg.AXOLOOTL_INSPECTOR.get()).getSortedIndex(), -1));
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof AxolootlInspectorBlockEntity) {
            AxolootlInspectorBlockEntity container = (AxolootlInspectorBlockEntity)blockEntity;
            return container.hasInspectorItems(pLevel) ? 15 : AbstractContainerMenu.m_38938_((Container)container);
        }
        return 0;
    }
}

