/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BubblerBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final int BUBBLE_COLUMN_CHECK_DELAY = 20;
    private static final Vec3 BUBBLE_RADIUS = new Vec3(0.375, 0.125, 0.375);

    public BubblerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean waterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected boolean canAnimateParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.canAnimateParticles(pState, pLevel, pPos, pRandom)) {
            return;
        }
        Vec3 vec = Vec3.m_82539_((Vec3i)pPos).m_82520_(0.0, 0.625, 0.0);
        BubblerBlock.addParticles(pLevel, vec, BUBBLE_RADIUS, (ParticleOptions)ParticleTypes.f_123795_, 2 + pRandom.m_188503_(3), 0.09, pRandom);
        BubblerBlock.addParticles(pLevel, vec, BUBBLE_RADIUS, (ParticleOptions)ParticleTypes.f_123774_, 6, 0.09, pRandom);
    }

    public static void addParticles(Level level, Vec3 pos, Vec3 radius, ParticleOptions particle, int count, double motion, RandomSource random) {
        for (int i = 0; i < count; ++i) {
            double dx = (random.m_188500_() - 0.5) * 2.0 * radius.m_7096_();
            double dy = (random.m_188500_() - 0.5) * 2.0 * radius.m_7098_();
            double dz = (random.m_188500_() - 0.5) * 2.0 * radius.m_7094_();
            double vx = (random.m_188500_() - 0.5) * 2.0 * motion;
            double vy = random.m_188500_() * 2.0 * motion;
            double vz = (random.m_188500_() - 0.5) * 2.0 * motion;
            level.m_7106_(particle, pos.m_7096_() + dx, pos.m_7098_() + dy, pos.m_7094_() + dz, vx, vy, vz);
        }
    }
}

