/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block;

import axolootl.block.WaterloggedHorizontalBlock;
import axolootl.util.ShapeUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WaterloggedHorizontalMultiBlock
extends WaterloggedHorizontalBlock {
    public static final IntegerProperty WIDTH = IntegerProperty.m_61631_((String)"width", (int)0, (int)2);
    public static final IntegerProperty HEIGHT = IntegerProperty.m_61631_((String)"height", (int)0, (int)2);
    public static final IntegerProperty DEPTH = IntegerProperty.m_61631_((String)"depth", (int)0, (int)2);
    private static final Vec3i CENTER = new Vec3i(1, 1, 1);
    public static final Direction ORIGIN_DIRECTION = Direction.NORTH;
    private final Map<BlockState, ShapeData> SHAPES = new HashMap<BlockState, ShapeData>();
    private final Map<Direction, VoxelShape> CENTERED_VISUAL_SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    private final Map<BlockState, VoxelShape> VISUAL_SHAPES = new HashMap<BlockState, VoxelShape>();
    private final Function<BlockState, ShapeData> shapes;

    public WaterloggedHorizontalMultiBlock(BlockBehaviour.Properties pProperties, Function<BlockState, ShapeData> shapes) {
        super(pProperties.m_60988_());
        this.shapes = shapes;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WIDTH, (Comparable)Integer.valueOf(1))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(1))).m_61124_((Property)DEPTH, (Comparable)Integer.valueOf(1)));
        this.precalculateShapes();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        Direction direction = pContext.m_8125_().m_122424_();
        BlockPos center = pContext.m_8083_();
        if (center.m_123342_() + 1 >= level.m_151558_()) {
            return null;
        }
        if (!WaterloggedHorizontalMultiBlock.allPositions(center, p -> level.m_8055_(p).m_60629_(pContext))) {
            return null;
        }
        boolean waterlogged = pContext.m_43725_().m_6425_(center).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_((Property)WIDTH, (Comparable)Integer.valueOf(1))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(1))).m_61124_((Property)DEPTH, (Comparable)Integer.valueOf(1));
    }

    protected void precalculateShapes() {
        this.SHAPES.clear();
        this.CENTERED_VISUAL_SHAPES.clear();
        this.VISUAL_SHAPES.clear();
        BlockState centerBlockState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WIDTH, (Comparable)Integer.valueOf(1))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(1))).m_61124_((Property)DEPTH, (Comparable)Integer.valueOf(1));
        VoxelShape centeredShape = this.createVisualShape(centerBlockState);
        this.CENTERED_VISUAL_SHAPES.putAll(ShapeUtils.rotateShapes(ORIGIN_DIRECTION, centeredShape));
        for (BlockState blockState : this.f_49792_.m_61056_()) {
            this.SHAPES.put(blockState, this.createShapeData(blockState));
            Vec3i index = WaterloggedHorizontalMultiBlock.getIndex(blockState);
            VoxelShape shape = this.CENTERED_VISUAL_SHAPES.get(blockState.m_61143_((Property)f_54117_)).m_83216_((double)(1 - index.m_123341_()), (double)(1 - index.m_123342_()), (double)(1 - index.m_123343_()));
            this.VISUAL_SHAPES.put(blockState, shape);
        }
    }

    public VoxelShape getVisualShape(BlockState blockState) {
        return this.VISUAL_SHAPES.get(blockState);
    }

    private VoxelShape createVisualShape(BlockState blockState) {
        Vec3i offset = WaterloggedHorizontalMultiBlock.getIndex(blockState);
        VoxelShape shape = Shapes.m_83040_();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    BlockState b = (BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)WIDTH, (Comparable)Integer.valueOf(x))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(y))).m_61124_((Property)DEPTH, (Comparable)Integer.valueOf(z));
                    shape = ShapeUtils.orUnoptimized(shape, this.getOrCreateShapeData(b).getCollisionShape().m_83216_((double)(x - offset.m_123341_()), (double)(y - offset.m_123342_()), (double)(z - offset.m_123343_())));
                }
            }
        }
        return shape.m_83296_();
    }

    protected ShapeData getOrCreateShapeData(BlockState blockState) {
        if (!this.SHAPES.containsKey(blockState)) {
            this.SHAPES.put(blockState, this.createShapeData(blockState));
        }
        return this.SHAPES.get(blockState);
    }

    public ShapeData getShapeData(BlockState blockState) {
        return this.SHAPES.get(blockState);
    }

    private ShapeData createShapeData(BlockState blockState) {
        return this.shapes.apply(blockState);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{WIDTH}).m_61104_(new Property[]{HEIGHT}).m_61104_(new Property[]{DEPTH});
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext context;
        ShapeData shapeData = this.getShapeData(pState);
        if (shapeData.getCollisionShape().m_83281_() || shapeData.isPassable() && pContext instanceof EntityCollisionContext && ShapeUtils.canEntityPass((context = (EntityCollisionContext)pContext).m_193113_())) {
            return Shapes.m_83040_();
        }
        return shapeData.getCollisionShape();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getVisualShape(pState);
    }

    @Override
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockPos center;
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (!WaterloggedHorizontalMultiBlock.allPositions(center = WaterloggedHorizontalMultiBlock.getCenter(pCurrentPos, pState), p -> pLevel.m_8055_(p).m_60713_((Block)this))) {
            return this.m_5888_(pState).m_76188_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockPos center = WaterloggedHorizontalMultiBlock.getCenter(pPos, pState);
        PositionIterator.accept(center, (p, x, y, z) -> {
            if (pPos.equals((Object)p)) {
                return;
            }
            boolean waterlogged = pLevel.m_6425_(p).m_76152_() == Fluids.f_76193_;
            BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_((Property)WIDTH, (Comparable)Integer.valueOf(x))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(y))).m_61124_((Property)DEPTH, (Comparable)Integer.valueOf(z));
            pLevel.m_7731_(p, state, 3);
        });
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (!pState.m_60713_((Block)this)) {
            return true;
        }
        return WaterloggedHorizontalMultiBlock.allPositions(WaterloggedHorizontalMultiBlock.getCenter(pPos, pState), p -> pLevel.m_8055_(p).m_60713_((Block)this));
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            WaterloggedHorizontalMultiBlock.preventCreativeDropFromCenterPart(pLevel, pPos, pState, pPlayer);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public static void preventCreativeDropFromCenterPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos center = WaterloggedHorizontalMultiBlock.getCenter(pPos, pState);
        BlockState blockState = pLevel.m_8055_(center);
        if (blockState.m_60713_(pState.m_60734_()) && WaterloggedHorizontalMultiBlock.getIndex(blockState).equals((Object)CENTER)) {
            pLevel.m_7731_(center, blockState.m_60819_().m_76188_(), 35);
        }
    }

    public static Vec3i getIndex(BlockState blockState) {
        return new Vec3i(((Integer)blockState.m_61143_((Property)WIDTH)).intValue(), ((Integer)blockState.m_61143_((Property)HEIGHT)).intValue(), ((Integer)blockState.m_61143_((Property)DEPTH)).intValue());
    }

    public static BlockPos getCenter(BlockPos pos, Vec3i indices) {
        return pos.m_7918_(-(indices.m_123341_() - 1), -(indices.m_123342_() - 1), -(indices.m_123343_() - 1));
    }

    public static BlockPos getCenter(BlockPos pos, BlockState blockState) {
        return WaterloggedHorizontalMultiBlock.getCenter(pos, WaterloggedHorizontalMultiBlock.getIndex(blockState));
    }

    public static Iterable<BlockPos> getPositions(BlockPos center) {
        return BlockPos.m_121976_((int)(center.m_123341_() - 1), (int)(center.m_123342_() - 1), (int)(center.m_123343_() - 1), (int)(center.m_123341_() + 1), (int)(center.m_123342_() + 1), (int)(center.m_123343_() + 1));
    }

    public static boolean allPositions(BlockPos center, Predicate<BlockPos> predicate) {
        for (BlockPos p : WaterloggedHorizontalMultiBlock.getPositions(center)) {
            if (predicate.test(p)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyPositions(BlockPos center, Predicate<BlockPos> predicate) {
        for (BlockPos p : WaterloggedHorizontalMultiBlock.getPositions(center)) {
            if (!predicate.test(p)) continue;
            return true;
        }
        return false;
    }

    protected static ShapeData createRotatedShapeData(BlockState blockState, ShapeData[][][] shapeData) {
        int width = (Integer)blockState.m_61143_((Property)WIDTH);
        int depth = (Integer)blockState.m_61143_((Property)DEPTH);
        int height = (Integer)blockState.m_61143_((Property)HEIGHT);
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        return WaterloggedHorizontalMultiBlock.createRotatedIndexedShape(new Vec3i(width, height, depth), ORIGIN_DIRECTION, facing, shapeData);
    }

    public static ShapeData createRotatedIndexedShape(Vec3i index, Direction originDirection, Direction direction, ShapeData[][][] template) {
        Vec3i rotatedIndex = WaterloggedHorizontalMultiBlock.rotateIndex(index, Direction.m_122407_((int)(direction.m_122416_() - originDirection.m_122416_() + 4)));
        ShapeData shapeData = template[rotatedIndex.m_123342_()][rotatedIndex.m_123341_()][rotatedIndex.m_123343_()];
        return new ShapeData(ShapeUtils.rotateShape(originDirection, direction, shapeData.getCollisionShape()), shapeData.isPassable());
    }

    public static Vec3i rotateIndex(Vec3i index, Direction direction) {
        switch (direction) {
            default: {
                return new Vec3i(-index.m_123341_() + 2, index.m_123342_(), -index.m_123343_() + 2);
            }
            case NORTH: {
                return new Vec3i(-index.m_123343_() + 2, index.m_123342_(), index.m_123341_());
            }
            case EAST: {
                return index;
            }
            case SOUTH: 
        }
        return new Vec3i(index.m_123343_(), index.m_123342_(), -index.m_123341_() + 2);
    }

    public static class ShapeData {
        private final VoxelShape collisionShape;
        private final boolean passable;

        public ShapeData(VoxelShape collisionShape) {
            this(collisionShape, collisionShape.m_83281_());
        }

        public ShapeData(VoxelShape collisionShape, boolean passable) {
            this.collisionShape = collisionShape;
            this.passable = passable;
        }

        public VoxelShape getCollisionShape() {
            return this.collisionShape;
        }

        public boolean isPassable() {
            return this.passable;
        }
    }

    @FunctionalInterface
    public static interface PositionIterator {
        public void accept(BlockPos var1, int var2, int var3, int var4);

        public static void accept(BlockPos center, PositionIterator iterator) {
            BlockPos.MutableBlockPos pos = center.m_122032_();
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    for (int z = 0; z < 3; ++z) {
                        pos.m_122154_((Vec3i)center, x - 1, y - 1, z - 1);
                        iterator.accept((BlockPos)pos, x, y, z);
                    }
                }
            }
        }
    }
}

