/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block.entity;

import axolootl.AxRegistry;
import axolootl.block.EnergyInterfaceBlock;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.block.entity.IAquariumControllerProvider;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.menu.CyclingMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyInterfaceBlockEntity
extends BlockEntity
implements IAquariumControllerProvider,
MenuProvider {
    protected EnergyStorage energy = new InternalEnergyStorage();
    private LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this.energy);
    private BlockPos controllerPos;
    private ControllerBlockEntity controller;
    private static final String KEY_ENERGY = "Energy";

    public EnergyInterfaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)AxRegistry.BlockEntityReg.ENERGY_INTERFACE.get(), pPos, pBlockState);
    }

    public EnergyInterfaceBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Override
    public void setController(Level level, BlockPos pos, ControllerBlockEntity blockEntity) {
        boolean isChanged = this.controllerPos != pos || this.controller != blockEntity;
        this.controllerPos = pos;
        this.controller = blockEntity;
        if (isChanged) {
            this.m_6596_();
        }
    }

    @Override
    public void clearController() {
        this.controllerPos = null;
        this.controller = null;
        this.m_6596_();
    }

    @Override
    public Optional<ControllerBlockEntity> getController() {
        if (this.controllerPos != null && null == this.controller && this.f_58857_ != null) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.controllerPos);
            if (blockEntity instanceof ControllerBlockEntity) {
                ControllerBlockEntity controller = (ControllerBlockEntity)blockEntity;
                this.setController(this.f_58857_, this.controllerPos, controller);
            } else {
                this.clearController();
            }
        }
        return Optional.ofNullable(this.controller);
    }

    public boolean validateController(Level level) {
        ControllerBlockEntity controllerBlockEntity;
        if (null == this.controllerPos) {
            this.controller = null;
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(this.controllerPos);
        if (blockEntity instanceof ControllerBlockEntity && (controllerBlockEntity = (ControllerBlockEntity)blockEntity) != this.controller) {
            this.controller = controllerBlockEntity;
            return true;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ENERGY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.holder = LazyOptional.of(() -> this.energy);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public boolean isMenuAvailable(Player player, ControllerBlockEntity controller) {
        return this.getController().isPresent() && ((IAquariumTab)AxRegistry.AquariumTabsReg.ENERGY_INTERFACE.get()).isAvailable(controller);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return CyclingMenu.createEnergy(pContainerId, pPlayerInventory, this.controllerPos, this.getController().get(), this.m_58899_(), ((IAquariumTab)AxRegistry.AquariumTabsReg.ENERGY_INTERFACE.get()).getSortedIndex(), -1);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        tag.m_128365_(KEY_ENERGY, this.energy.serializeNBT());
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.controllerPos = this.readControllerPos(tag);
        if (tag.m_128425_(KEY_ENERGY, 3)) {
            this.energy.deserializeNBT(tag.m_128423_(KEY_ENERGY));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeControllerPos(this.controllerPos, tag);
    }

    private class InternalEnergyStorage
    extends EnergyStorage {
        private static final int CAPACITY = 10000;
        private static final int TRANSFER = 10000;

        public InternalEnergyStorage() {
            super(10000, 10000);
        }

        public boolean canExtract() {
            return (Boolean)EnergyInterfaceBlockEntity.this.m_58900_().m_61143_((Property)EnergyInterfaceBlock.POWERED) == false;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int value = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && value != 0) {
                EnergyInterfaceBlockEntity.this.m_6596_();
                EnergyInterfaceBlockEntity.this.f_58857_.m_7260_(EnergyInterfaceBlockEntity.this.m_58899_(), EnergyInterfaceBlockEntity.this.m_58900_(), EnergyInterfaceBlockEntity.this.m_58900_(), 2);
            }
            return value;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int value = super.extractEnergy(maxExtract, simulate);
            if (!simulate && value != 0) {
                EnergyInterfaceBlockEntity.this.m_6596_();
                EnergyInterfaceBlockEntity.this.f_58857_.m_7260_(EnergyInterfaceBlockEntity.this.m_58899_(), EnergyInterfaceBlockEntity.this.m_58900_(), EnergyInterfaceBlockEntity.this.m_58900_(), 2);
            }
            return value;
        }
    }
}

