/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block.entity;

import axolootl.AxRegistry;
import axolootl.block.WaterInterfaceBlock;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.block.entity.InterfaceBlockEntity;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.menu.CyclingContainerMenu;
import axolootl.util.TankMultiblock;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterInterfaceBlockEntity
extends InterfaceBlockEntity {
    public static final long BASE_SPEED_DECREMENT = 100L;
    public static final int FLUIDS_SCANNED_PER_TICK = 20;
    public static final int FLUID_UPDATE_INTERVAL = 80;
    private double placeFluidSpeed = 1.0;
    private long placeFluidTime;
    private boolean fillTopLayer;
    private boolean isObstructed;
    private boolean forceUpdateObstructed = true;
    private Iterator<BlockPos> placeFluidIterator;
    protected FluidTank tank = new FluidTank(12000).setValidator(f -> f.getFluid().getFluidType() == ForgeMod.WATER_TYPE.get());
    private LazyOptional<IFluidHandler> holder = this.createFluidHolder();
    private static final String KEY_FILL_TOP_LAYER = "FillTopLayer";
    private static final String KEY_FORCE_OBSTRUCTED_UPDATE = "UpdateObstructed";
    private static final String KEY_OBSTRUCTED = "Obstructed";

    public WaterInterfaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)AxRegistry.BlockEntityReg.WATER_INTERFACE.get(), pPos, pBlockState);
    }

    public WaterInterfaceBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState, 1, 1);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WaterInterfaceBlockEntity self) {
        FluidStack fluidStack;
        Optional<ControllerBlockEntity> oController = self.getController();
        if (oController.isEmpty() || !oController.get().hasTank() || !oController.get().getTankStatus().isActive()) {
            return;
        }
        boolean markDirty = false;
        markDirty |= self.validateController(level);
        markDirty |= self.updateTickers(level);
        IFluidHandler fluidHandler = (IFluidHandler)self.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse((Object)EmptyFluidHandler.INSTANCE);
        Optional itemHandler = self.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        markDirty |= self.consumeFluid(level, itemHandler, fluidHandler);
        if (self.forceUpdateObstructed) {
            self.updateObstructed(level, pos, state, (Fluid)Fluids.f_76193_, (Fluid)Fluids.f_76192_);
            self.forceUpdateObstructed = false;
            markDirty = true;
        }
        if (!((Boolean)state.m_61143_((Property)WaterInterfaceBlock.POWERED)).booleanValue() && !self.isObstructed() && (fluidStack = fluidHandler.getFluidInTank(0)).getFluid().m_6212_((Fluid)Fluids.f_76193_) && fluidStack.getAmount() >= 1000) {
            markDirty |= self.tickPlaceFluid(level, fluidHandler);
        }
        if (markDirty) {
            self.m_6596_();
            level.m_7260_(pos, state, state, 2);
        }
    }

    @Override
    public boolean isMenuAvailable(Player player, ControllerBlockEntity controller) {
        return ((IAquariumTab)AxRegistry.AquariumTabsReg.FLUID_INTERFACE.get()).isAvailable(controller);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return CyclingContainerMenu.createFluid(pContainerId, pPlayerInventory, this.controllerPos, this.getController().get(), this.m_58899_(), ((IAquariumTab)AxRegistry.AquariumTabsReg.FLUID_INTERFACE.get()).getSortedIndex(), -1);
    }

    @Override
    public void clearController() {
        this.placeFluidIterator = null;
        super.clearController();
    }

    private LazyOptional<IFluidHandler> createFluidHolder() {
        return LazyOptional.of(() -> this.tank);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    @Override
    public void reviveCaps() {
        super.reviveCaps();
        this.holder = this.createFluidHolder();
    }

    private boolean updateTickers(Level level) {
        if (this.placeFluidTime > 0L) {
            long tickAmount = this.getPlaceFluidTickAmount();
            this.placeFluidTime = Math.max(0L, this.placeFluidTime - tickAmount);
            return true;
        }
        return false;
    }

    public long getPlaceFluidTickAmount() {
        return Mth.m_14107_((double)(100.0 * this.placeFluidSpeed));
    }

    private boolean consumeFluid(Level level, Optional<IItemHandler> oHandler, IFluidHandler fluidHandler) {
        if (oHandler.isEmpty()) {
            return false;
        }
        IItemHandler itemHandler = oHandler.get();
        boolean hasConsumed = false;
        int n = itemHandler.getSlots();
        for (int i = 0; i < n; ++i) {
            IFluidHandlerItem fluidItem;
            FluidStack fluidStack;
            Optional oFluidItem;
            ItemStack itemStack = itemHandler.extractItem(i, 1, true);
            if (itemStack.m_41619_() || (oFluidItem = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve()).isEmpty() || fluidHandler.fill(fluidStack = (fluidItem = (IFluidHandlerItem)oFluidItem.get()).getFluidInTank(0), IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
            itemHandler.extractItem(i, 1, false);
            if (fluidHandler.fill(fluidItem.drain(fluidStack.getAmount(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE) <= 0) continue;
            hasConsumed = true;
            ItemStack remainder = itemHandler.insertItem(i, fluidItem.getContainer(), false);
            if (remainder.m_41619_()) continue;
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Vec3 pos = Vec3.m_82512_((Vec3i)this.m_58899_()).m_231075_(facing, 0.6);
            level.m_7967_((Entity)new ItemEntity(level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), remainder));
        }
        return hasConsumed;
    }

    public boolean fillTopLayer() {
        return this.fillTopLayer;
    }

    public boolean isObstructed() {
        return this.isObstructed;
    }

    public void forceUpdateObstructed() {
        this.forceUpdateObstructed = true;
        this.m_6596_();
    }

    public boolean updateObstructed(Level level, BlockPos origin, BlockState blockState, Fluid fluid, Fluid flowing) {
        if (!this.hasTank()) {
            return false;
        }
        BoundingBox b = this.controller.getSize().orElse(TankMultiblock.Size.EMPTY).boundingBox();
        BoundingBox bounds = new BoundingBox(b.m_162395_() + 1, b.m_162396_() + 1, b.m_162398_() + 1, b.m_162399_() - 1, b.m_162400_() - (this.fillTopLayer() ? 1 : 2), b.m_162401_() - 1);
        BlockPos neighbor = origin.m_121945_(((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_());
        boolean wasObstructed = this.isObstructed;
        this.isObstructed = !bounds.m_71051_((Vec3i)neighbor) || !this.isFluidSource(level, neighbor, fluid) && !this.placeFluidBlock(level, neighbor, fluid, flowing, true);
        return wasObstructed != this.isObstructed;
    }

    private boolean tickPlaceFluid(Level level, IFluidHandler fluidHandler) {
        if (this.isObstructed) {
            return false;
        }
        if (this.placeFluidTime > 0L) {
            return false;
        }
        if (!this.hasTank()) {
            return false;
        }
        int amount = 1000;
        FluidStack fluidStack = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        if (fluidHandler.drain(fluidStack, IFluidHandler.FluidAction.SIMULATE).getAmount() < 1000) {
            return false;
        }
        Optional<BlockPos> oPos = this.findPlaceablePosition(level, this.m_58899_(), (Fluid)Fluids.f_76193_, (Fluid)Fluids.f_76192_);
        if (oPos.isEmpty() || !this.placeFluidBlock(level, oPos.get(), (Fluid)Fluids.f_76193_, (Fluid)Fluids.f_76192_, false)) {
            return false;
        }
        fluidHandler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        this.placeFluidTime = 8000L;
        return true;
    }

    private Iterator<BlockPos> createIterator(Level level, BlockPos origin) {
        BoundingBox b = this.controller.getSize().orElse(TankMultiblock.Size.EMPTY).boundingBox();
        BoundingBox bounds = new BoundingBox(b.m_162395_() + 1, b.m_162396_() + 1, b.m_162398_() + 1, b.m_162399_() - 1, b.m_162400_() - (this.fillTopLayer() ? 1 : 2), b.m_162401_() - 1);
        BlockPos neighbor = origin.m_121945_(((Direction)level.m_8055_(origin).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_());
        return new PlaceFluidIterator(origin, neighbor, bounds);
    }

    private Optional<BlockPos> findPlaceablePosition(Level level, BlockPos origin, Fluid fluid, Fluid flowing) {
        if (null == this.placeFluidIterator || !this.placeFluidIterator.hasNext()) {
            this.placeFluidIterator = this.createIterator(level, origin);
        }
        int steps = 20;
        while (this.placeFluidIterator.hasNext() && steps-- > 0) {
            BlockPos p = this.placeFluidIterator.next();
            if (!this.placeFluidBlock(level, p, fluid, flowing, true)) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    private boolean isFluidSource(Level level, BlockPos pos, Fluid fluid) {
        return level.m_6425_(pos).m_192917_(fluid);
    }

    private boolean placeFluidBlock(Level level, BlockPos pos, Fluid fluid, Fluid flowing, boolean simulate) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer container = (LiquidBlockContainer)block;
            return simulate ? container.m_6044_((BlockGetter)level, pos, blockState, fluid) : container.m_7361_((LevelAccessor)level, pos, blockState, fluid.m_76145_());
        }
        if (blockState.m_60795_() || blockState.m_60819_().m_192917_(flowing)) {
            return simulate || level.m_7731_(pos, fluid.m_76145_().m_76188_(), 3);
        }
        return false;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag);
        this.fillTopLayer = tag.m_128471_(KEY_FILL_TOP_LAYER);
        this.isObstructed = tag.m_128471_(KEY_OBSTRUCTED);
        this.forceUpdateObstructed = tag.m_128471_(KEY_FORCE_OBSTRUCTED_UPDATE);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.tank.writeToNBT(tag);
        tag.m_128379_(KEY_FILL_TOP_LAYER, this.fillTopLayer);
        tag.m_128379_(KEY_OBSTRUCTED, this.isObstructed);
        tag.m_128379_(KEY_FORCE_OBSTRUCTED_UPDATE, this.forceUpdateObstructed);
    }

    public static class PlaceFluidIterator
    implements Iterator<BlockPos> {
        private final Set<Long> invalidSuperSet;
        private final Set<Long> invalid;
        private final BlockPos start;
        private final BlockPos.MutableBlockPos min;
        private final BlockPos.MutableBlockPos max;
        private final BlockPos origin;
        private final BoundingBox bounds;
        private final BlockPos.MutableBlockPos cursor;
        private BlockPos.MutableBlockPos next;
        private int layer;
        private Iterator<BlockPos> iterator;

        public PlaceFluidIterator(BlockPos origin, BlockPos start, BoundingBox bounds) {
            this.origin = origin.m_7949_();
            this.start = start.m_7949_();
            this.bounds = bounds;
            this.min = start.m_122032_();
            this.max = start.m_122032_();
            this.cursor = start.m_122032_();
            this.next = start.m_122032_();
            this.layer = bounds.m_162396_() - start.m_123342_();
            this.invalidSuperSet = new HashSet<Long>();
            this.invalid = new HashSet<Long>();
            this.iterator = this.calculateNextIterator();
        }

        private boolean isReachedMaxLayer() {
            int maxLayer = this.bounds.m_162400_() - this.start.m_123342_();
            return this.layer > maxLayer;
        }

        private boolean isReachedMaxBounds() {
            return this.max.m_123341_() - this.min.m_123341_() >= this.bounds.m_162399_() - this.bounds.m_162395_() && this.max.m_123343_() - this.min.m_123343_() >= this.bounds.m_162401_() - this.bounds.m_162398_();
        }

        private Iterator<BlockPos> calculateNextIterator() {
            if (this.isReachedMaxBounds()) {
                ++this.layer;
                this.invalid.clear();
                this.min.m_122154_((Vec3i)this.start, 0, this.layer, 0);
                this.max.m_122154_((Vec3i)this.start, 0, this.layer, 0);
                if (this.isReachedMaxLayer()) {
                    return Collections.emptyIterator();
                }
            } else {
                this.min.m_122178_(Math.max(this.bounds.m_162395_(), this.min.m_123341_() - 1), this.min.m_123342_(), Math.max(this.bounds.m_162398_(), this.min.m_123343_() - 1));
                this.max.m_122178_(Math.min(this.bounds.m_162399_(), this.max.m_123341_() + 1), this.max.m_123342_(), Math.min(this.bounds.m_162401_(), this.max.m_123343_() + 1));
            }
            return BlockPos.m_121940_((BlockPos)this.min, (BlockPos)this.max).iterator();
        }

        private Optional<BlockPos> calculateNext() {
            while (this.iterator.hasNext()) {
                long key;
                BlockPos p = this.iterator.next();
                if (!this.iterator.hasNext()) {
                    this.iterator = this.calculateNextIterator();
                }
                if (this.invalid.contains(key = p.m_121878_()) || this.invalidSuperSet.contains(key)) continue;
                this.invalid.add(key);
                return Optional.of(p);
            }
            return Optional.empty();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public BlockPos next() {
            this.cursor.m_122190_((Vec3i)this.next);
            this.calculateNext().ifPresentOrElse(p -> this.next.m_122190_((Vec3i)p), () -> {
                this.next = null;
            });
            return this.cursor;
        }

        @Override
        public void remove() {
            this.invalidSuperSet.add(this.cursor.m_121878_());
        }

        @Override
        public void forEachRemaining(Consumer<? super BlockPos> action) {
            while (this.hasNext()) {
                action.accept((BlockPos)this.next());
            }
        }
    }
}

