/*
 * Decompiled with CFR 0.152.
 */
package axolootl.capability;

import axolootl.Axolootl;
import axolootl.network.AxNetwork;
import axolootl.network.ClientBoundSyncAxolootlResearchCapabilityPacket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class AxolootlResearchCapability
implements INBTSerializable<ListTag> {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("axolootl", "research");
    public static final AxolootlResearchCapability EMPTY = new AxolootlResearchCapability();
    public Collection<ResourceLocation> axolootls = new HashSet<ResourceLocation>();
    public Collection<ResourceLocation> axolootlsView = Collections.unmodifiableCollection(this.axolootls);

    public static Provider provider() {
        return new Provider();
    }

    public Collection<ResourceLocation> getAxolootls() {
        return this.axolootlsView;
    }

    public boolean addAxolootl(ResourceLocation id) {
        return this.axolootls.add(id);
    }

    public boolean addAxolootls(Collection<ResourceLocation> ids) {
        return this.axolootls.addAll(ids);
    }

    public boolean addAxolootl(ServerPlayer player, ResourceLocation id) {
        if (this.addAxolootl(id)) {
            this.syncToClient(player);
            return true;
        }
        return false;
    }

    public boolean removeAxolootl(ResourceLocation id) {
        return this.axolootls.remove(id);
    }

    public boolean removeAxolootl(ServerPlayer player, ResourceLocation id) {
        if (this.removeAxolootl(id)) {
            this.syncToClient(player);
            return true;
        }
        return false;
    }

    public boolean clear(ServerPlayer player) {
        if (this.clear()) {
            this.syncToClient(player);
            return true;
        }
        return false;
    }

    public boolean clear() {
        int size = this.axolootls.size();
        this.axolootls.clear();
        return size > 0;
    }

    public boolean containsAxolootl(ResourceLocation id) {
        return this.axolootls.contains(id);
    }

    public ListTag serializeNBT() {
        ListTag listTag = new ListTag();
        for (ResourceLocation id : this.axolootls) {
            listTag.add((Object)StringTag.m_129297_((String)id.toString()));
        }
        return listTag;
    }

    public void deserializeNBT(ListTag tag) {
        this.axolootls.clear();
        if (tag.m_7264_() != 8) {
            return;
        }
        int n = tag.size();
        for (int i = 0; i < n; ++i) {
            this.axolootls.add(new ResourceLocation(tag.m_128778_(i)));
        }
    }

    public void syncToClient(ServerPlayer serverPlayer) {
        AxNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientBoundSyncAxolootlResearchCapabilityPacket(this));
    }

    public static class Provider
    implements ICapabilitySerializable<ListTag> {
        private final AxolootlResearchCapability instance = new AxolootlResearchCapability();
        private final LazyOptional<AxolootlResearchCapability> storage = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == Axolootl.AXOLOOTL_RESEARCH_CAPABILITY) {
                return this.storage.cast();
            }
            return LazyOptional.empty();
        }

        public ListTag serializeNBT() {
            return this.instance.serializeNBT();
        }

        public void deserializeNBT(ListTag tag) {
            this.instance.deserializeNBT(tag);
        }
    }
}

