/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client;

import axolootl.AxRegistry;
import axolootl.block.GrandCastleMultiBlock;
import axolootl.client.AxolootlBucketItemModelLoader;
import axolootl.client.blockentity.AutofeederBlockEntityRenderer;
import axolootl.client.entity.AxolootlGeoRenderer;
import axolootl.client.menu.AxolootlInspectorScreen;
import axolootl.client.menu.AxolootlInterfaceScreen;
import axolootl.client.menu.ControllerScreen;
import axolootl.client.menu.CyclingContainerScreen;
import axolootl.client.menu.EnergyInterfaceScreen;
import axolootl.client.menu.FluidInterfaceScreen;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.item.AxolootlBucketItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ClientEvents {
    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register(ModHandler.class);
        MinecraftForge.EVENT_BUS.register(ForgeHandler.class);
        AxolootlBucketItemModelLoader.register();
    }

    public static final class ModHandler {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(ModHandler::onRegisterScreens);
            event.enqueueWork(ModHandler::onRegisterItemPropertyOverrides);
        }

        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)AxRegistry.EntityReg.AXOLOOTL.get(), AxolootlGeoRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)AxRegistry.BlockEntityReg.AUTO_FEEDER.get(), AutofeederBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
            event.register((pStack, pTintIndex) -> {
                if (pTintIndex < 1 || pTintIndex > 2) {
                    return -1;
                }
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (null == level) {
                    return -1;
                }
                AxolootlVariant variant = AxolootlBucketItem.getVariant(level.m_8891_(), pStack).orElse(AxolootlVariant.EMPTY);
                if (pTintIndex == 1) {
                    return variant.getModelSettings().getPrimaryColor();
                }
                return variant.getModelSettings().getSecondaryColor();
            }, new ItemLike[]{(ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get()});
        }

        private static void onRegisterScreens() {
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.CONTROLLER.get()), ControllerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.AXOLOOTL.get()), AxolootlInterfaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.INSPECTOR.get()), AxolootlInspectorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.OUTPUT.get()), CyclingContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.LARGE_OUTPUT.get()), CyclingContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.AUTOFEEDER.get()), CyclingContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.BREEDER.get()), CyclingContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.MONSTERIUM.get()), CyclingContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.ENERGY.get()), EnergyInterfaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)AxRegistry.MenuReg.FLUID.get()), FluidInterfaceScreen::new);
        }

        private static void onRegisterItemPropertyOverrides() {
            ItemProperties.register((Item)((Item)RegistryObject.create((ResourceLocation)new ResourceLocation("axolootl", "grand_castle"), (IForgeRegistry)ForgeRegistries.ITEMS).get()), (ResourceLocation)new ResourceLocation("axolootl", "enchantment"), (pStack, pLevel, pEntity, pSeed) -> (float)pStack.getEnchantmentLevel(GrandCastleMultiBlock.ENCHANTMENT) / 3.0f);
            ItemProperties.register((Item)((Item)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get()), (ResourceLocation)new ResourceLocation("axolootl", "baby"), (pStack, pLevel, pEntity, pSeed) -> AxolootlBucketItem.isBaby(pStack) ? 1.0f : 0.0f);
        }
    }

    public static final class ForgeHandler {
    }
}

