/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.entity;

import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.entity.IAxolootl;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LerpingModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector3f;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class AxolootlGeoModel<T extends LivingEntity & IAxolootl>
extends DefaultedEntityGeoModel<T> {
    private static final ResourceLocation EMPTY_ANIMATIONS = new ResourceLocation("axolootl", "animations/entity/axolootl/axolootl.animation.json");
    private static final String TAIL = "tail";
    private static final String LEFT_HIND_LEG = "left_hind_leg";
    private static final String RIGHT_HIND_LEG = "right_hind_leg";
    private static final String LEFT_FRONT_LEG = "left_front_leg";
    private static final String RIGHT_FRONT_LEG = "right_front_leg";
    private static final String BODY = "body";
    private static final String HEAD = "head";
    private static final String TOP_GILLS = "top_gills";
    private static final String LEFT_GILLS = "left_gills";
    private static final String RIGHT_GILLS = "right_gills";
    private CoreGeoBone tail;
    private CoreGeoBone leftHindLeg;
    private CoreGeoBone rightHindLeg;
    private CoreGeoBone leftFrontLeg;
    private CoreGeoBone rightFrontLeg;
    private CoreGeoBone body;
    private CoreGeoBone head;
    private CoreGeoBone topGills;
    private CoreGeoBone leftGills;
    private CoreGeoBone rightGills;

    public AxolootlGeoModel() {
        super(new ResourceLocation("axolootl", "axolootl"), false);
    }

    public ResourceLocation getModelResource(T entity) {
        return ((IAxolootl)entity).getAxolootlVariant(((LivingEntity)entity).f_19853_.m_8891_()).orElse(AxolootlVariant.EMPTY).getModelSettings().getEntityGeoModel();
    }

    public ResourceLocation getTextureResource(T entity) {
        return ((IAxolootl)entity).getAxolootlVariant(((LivingEntity)entity).f_19853_.m_8891_()).orElse(AxolootlVariant.EMPTY).getModelSettings().getEntityTexture();
    }

    public ResourceLocation getAnimationResource(T entity) {
        return ((IAxolootl)entity).getAxolootlVariant(((LivingEntity)entity).f_19853_.m_8891_()).orElse(AxolootlVariant.EMPTY).getModelSettings().getOptionalEntityGeoAnimations().orElse(EMPTY_ANIMATIONS);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    public void setCustomAnimations(T entity, long instanceId, AnimationState<T> animationState) {
        super.setCustomAnimations(entity, instanceId, animationState);
        if (EMPTY_ANIMATIONS.equals((Object)this.getAnimationResource(entity))) {
            this.setAxolotlAnimations(entity, instanceId, animationState);
        }
    }

    public void setAxolotlAnimations(T entity, long uniqueID, AnimationState<?> event) {
        float partialTick = event.getPartialTick();
        float ageInTicks = (float)((LivingEntity)entity).f_19797_ + partialTick;
        Vec2 headRotations = this.getHeadRotations(event);
        float headPitch = headRotations.f_82470_;
        float netHeadYaw = headRotations.f_82471_;
        this.tail = this.getAnimationProcessor().getBone(TAIL);
        this.leftHindLeg = this.getAnimationProcessor().getBone(LEFT_HIND_LEG);
        this.rightHindLeg = this.getAnimationProcessor().getBone(RIGHT_HIND_LEG);
        this.leftFrontLeg = this.getAnimationProcessor().getBone(LEFT_FRONT_LEG);
        this.rightFrontLeg = this.getAnimationProcessor().getBone(RIGHT_FRONT_LEG);
        this.body = this.getAnimationProcessor().getBone(BODY);
        this.head = this.getAnimationProcessor().getBone(HEAD);
        this.topGills = this.getAnimationProcessor().getBone(TOP_GILLS);
        this.leftGills = this.getAnimationProcessor().getBone(LEFT_GILLS);
        this.rightGills = this.getAnimationProcessor().getBone(RIGHT_GILLS);
        if (null == this.tail || null == this.leftHindLeg || null == this.rightHindLeg || null == this.leftFrontLeg || null == this.rightFrontLeg || null == this.body || null == this.head || null == this.leftGills || null == this.rightGills) {
            return;
        }
        this.setupInitialAnimationValues(entity, netHeadYaw, headPitch);
        if (((IAxolootl)entity).isEntityPlayingDead()) {
            this.setupPlayDeadAnimation(netHeadYaw);
            this.saveAnimationValues(entity);
        } else {
            boolean flag;
            boolean bl = flag = entity.m_20184_().m_165925_() > 1.0E-7 || entity.m_146909_() != ((LivingEntity)entity).f_19860_ || entity.m_146908_() != ((LivingEntity)entity).f_19859_ || ((LivingEntity)entity).f_19790_ != entity.m_20185_() || ((LivingEntity)entity).f_19792_ != entity.m_20189_();
            if (entity.m_20072_()) {
                if (flag) {
                    this.setupSwimmingAnimation(ageInTicks, headPitch);
                } else {
                    this.setupWaterHoveringAnimation(ageInTicks);
                }
                this.saveAnimationValues(entity);
            } else {
                if (entity.m_20096_()) {
                    if (flag) {
                        this.setupGroundCrawlingAnimation(ageInTicks, netHeadYaw);
                    } else {
                        this.setupLayStillOnGroundAnimation(ageInTicks, netHeadYaw);
                    }
                }
                this.saveAnimationValues(entity);
            }
        }
    }

    protected void setupInitialAnimationValues(T entity, float netHeadYaw, float headPitch) {
        this.body.setPosX(0.0f);
        this.body.setPosY(0.0f);
        this.head.setPosY(0.0f);
        Map map = ((LerpingModel)entity).m_142115_();
        if (map.isEmpty()) {
            this.setRotations(this.body, headPitch * ((float)Math.PI / 180), netHeadYaw * ((float)Math.PI / 180), 0.0f);
            this.setRotations(this.head, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.leftHindLeg, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.rightHindLeg, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.leftFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.rightFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.leftGills, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.rightGills, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.topGills, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.tail, 0.0f, 0.0f, 0.0f);
        } else {
            this.setRotationFromVector(this.body, (Vector3f)map.get(BODY));
            this.setRotationFromVector(this.head, (Vector3f)map.get(HEAD));
            this.setRotationFromVector(this.leftHindLeg, (Vector3f)map.get(LEFT_HIND_LEG));
            this.setRotationFromVector(this.rightHindLeg, (Vector3f)map.get(RIGHT_HIND_LEG));
            this.setRotationFromVector(this.leftFrontLeg, (Vector3f)map.get(LEFT_FRONT_LEG));
            this.setRotationFromVector(this.rightFrontLeg, (Vector3f)map.get(RIGHT_FRONT_LEG));
            this.setRotationFromVector(this.leftGills, (Vector3f)map.get(LEFT_GILLS));
            this.setRotationFromVector(this.rightGills, (Vector3f)map.get(RIGHT_GILLS));
            this.setRotationFromVector(this.topGills, (Vector3f)map.get(TOP_GILLS));
            this.setRotationFromVector(this.tail, (Vector3f)map.get(TAIL));
        }
    }

    protected Vector3f getRotationVector(CoreGeoBone bone) {
        return new Vector3f(bone.getRotX(), bone.getRotY(), bone.getRotZ());
    }

    protected void setRotationFromVector(CoreGeoBone bone, Vector3f vec) {
        this.setRotations(bone, vec.x(), vec.y(), vec.z());
    }

    protected float lerpTo(float start, float end) {
        return this.lerpTo(0.05f, start, end);
    }

    protected float lerpTo(float delta, float start, float end) {
        return Mth.m_14189_((float)delta, (float)start, (float)end);
    }

    protected void lerpPart(CoreGeoBone bone, float deltaX, float deltaY, float deltaZ) {
        this.setRotations(bone, this.lerpTo(bone.getRotX(), deltaX), this.lerpTo(bone.getRotY(), deltaY), this.lerpTo(bone.getRotZ(), deltaZ));
    }

    protected void saveAnimationValues(T entity) {
        Map map = ((LerpingModel)entity).m_142115_();
        map.put(BODY, this.getRotationVector(this.body));
        map.put(HEAD, this.getRotationVector(this.head));
        map.put(RIGHT_HIND_LEG, this.getRotationVector(this.rightHindLeg));
        map.put(LEFT_HIND_LEG, this.getRotationVector(this.leftHindLeg));
        map.put(RIGHT_FRONT_LEG, this.getRotationVector(this.rightFrontLeg));
        map.put(LEFT_FRONT_LEG, this.getRotationVector(this.leftFrontLeg));
        map.put(TAIL, this.getRotationVector(this.tail));
        map.put(TOP_GILLS, this.getRotationVector(this.topGills));
        map.put(LEFT_GILLS, this.getRotationVector(this.leftGills));
        map.put(RIGHT_GILLS, this.getRotationVector(this.rightGills));
    }

    protected void setRotations(CoreGeoBone bone, float x, float y, float z) {
        bone.setRotX(x);
        bone.setRotY(y);
        bone.setRotZ(z);
    }

    protected Vec2 getHeadRotations(AnimationState<?> event) {
        EntityModelData data = (EntityModelData)event.getData(DataTickets.ENTITY_MODEL_DATA);
        return new Vec2(data.headPitch(), data.netHeadYaw()).m_165903_((float)Math.PI / 180);
    }

    protected void setupLayStillOnGroundAnimation(float ageInTicks, float netHeadYaw) {
        float scaledAgeInTicks = ageInTicks * 0.09f;
        float sinAgeInTicks = Mth.m_14031_((float)scaledAgeInTicks);
        float cosAgeInTicks = Mth.m_14089_((float)scaledAgeInTicks);
        float f3 = sinAgeInTicks * sinAgeInTicks - 2.0f * sinAgeInTicks;
        float f4 = cosAgeInTicks * cosAgeInTicks - 3.0f * sinAgeInTicks;
        this.head.setRotX(this.lerpTo(this.head.getRotX(), -0.09f * f3));
        this.head.setRotY(this.lerpTo(this.head.getRotY(), 0.0f));
        this.head.setRotZ(this.lerpTo(this.head.getRotZ(), -0.2f));
        this.tail.setRotY(this.lerpTo(this.tail.getRotY(), -0.1f + 0.1f * f3));
        this.topGills.setRotX(this.lerpTo(this.topGills.getRotX(), 0.6f + 0.05f * f4));
        this.leftGills.setRotY(this.lerpTo(this.leftGills.getRotY(), -this.topGills.getRotX()));
        this.rightGills.setRotY(this.lerpTo(this.rightGills.getRotY(), -this.leftGills.getRotY()));
        this.lerpPart(this.leftHindLeg, 1.1f, 1.0f, 0.0f);
        this.lerpPart(this.leftFrontLeg, 0.8f, 2.3f, -0.5f);
        this.applyMirrorLegRotations();
        this.body.setRotX(this.lerpTo(0.2f, this.body.getRotX(), 0.0f));
        this.body.setRotY(this.lerpTo(this.body.getRotY(), netHeadYaw * ((float)Math.PI / 180)));
        this.body.setRotZ(this.lerpTo(this.body.getRotZ(), 0.0f));
    }

    protected void setupGroundCrawlingAnimation(float ageInTicks, float netHeadYaw) {
        float scaledAgeInTicks = ageInTicks * 0.11f;
        float cosAgeInTicks = Mth.m_14089_((float)scaledAgeInTicks);
        float f2 = (cosAgeInTicks * cosAgeInTicks - 2.0f * cosAgeInTicks) / 5.0f;
        float scaledCosAgeInTicks = 0.7f * cosAgeInTicks;
        this.head.setRotX(this.lerpTo(this.head.getRotX(), 0.0f));
        this.head.setRotY(this.lerpTo(this.head.getRotY(), 0.09f * cosAgeInTicks));
        this.head.setRotZ(this.lerpTo(this.head.getRotZ(), 0.0f));
        this.tail.setRotY(this.lerpTo(this.tail.getRotY(), this.head.getRotY()));
        this.topGills.setRotX(this.lerpTo(this.topGills.getRotX(), 0.6f - 0.08f * (cosAgeInTicks * cosAgeInTicks + 2.0f * Mth.m_14031_((float)scaledAgeInTicks))));
        this.leftGills.setRotY(this.lerpTo(this.leftGills.getRotY(), -this.topGills.getRotX()));
        this.rightGills.setRotY(this.lerpTo(this.rightGills.getRotY(), -this.leftGills.getRotY()));
        this.lerpPart(this.leftHindLeg, 0.9424779f, 1.5f - f2, 0.1f);
        this.lerpPart(this.leftFrontLeg, 1.0995574f, 1.5707964f - scaledCosAgeInTicks, 0.0f);
        this.lerpPart(this.rightHindLeg, this.leftHindLeg.getRotX(), -1.0f - f2, 0.0f);
        this.lerpPart(this.rightFrontLeg, this.leftFrontLeg.getRotX(), -1.5707964f - scaledCosAgeInTicks, 0.0f);
        this.body.setRotX(this.lerpTo(0.2f, this.body.getRotX(), 0.0f));
        this.body.setRotY(this.lerpTo(this.body.getRotY(), netHeadYaw * ((float)Math.PI / 180)));
        this.body.setRotZ(this.lerpTo(this.body.getRotZ(), 0.0f));
    }

    protected void setupWaterHoveringAnimation(float ageInTicks) {
        float scaledAgeInTicks = ageInTicks * 0.075f;
        float cosAgeInTicks = Mth.m_14089_((float)scaledAgeInTicks);
        float sinAgeInTicks = Mth.m_14031_((float)scaledAgeInTicks) * 0.15f;
        this.body.setRotX(this.lerpTo(this.body.getRotX(), -0.15f + 0.075f * cosAgeInTicks));
        this.head.setRotX(this.lerpTo(this.head.getRotX(), -this.body.getRotX()));
        this.topGills.setRotX(this.lerpTo(this.topGills.getRotX(), 0.2f * cosAgeInTicks));
        this.leftGills.setRotY(this.lerpTo(this.leftGills.getRotY(), -0.3f * cosAgeInTicks - 0.19f));
        this.rightGills.setRotY(this.lerpTo(this.rightGills.getRotY(), -this.leftGills.getRotY()));
        this.lerpPart(this.leftHindLeg, -(2.3561945f - cosAgeInTicks * 0.11f), -0.47123894f, 1.7278761f);
        this.lerpPart(this.leftFrontLeg, -(0.7853982f - cosAgeInTicks * 0.2f), -2.042035f, 0.0f);
        this.applyMirrorLegRotations();
        this.tail.setRotY(this.lerpTo(this.tail.getRotY(), 0.5f * cosAgeInTicks));
        this.head.setRotY(this.lerpTo(this.head.getRotY(), 0.0f));
        this.head.setRotZ(this.lerpTo(this.head.getRotZ(), 0.0f));
    }

    protected void setupSwimmingAnimation(float ageInTicks, float headPitch) {
        float scaledAgeInTicks = ageInTicks * 0.33f;
        float sinAgeInTicks = Mth.m_14031_((float)scaledAgeInTicks);
        float cosAgeInTicks = Mth.m_14089_((float)scaledAgeInTicks);
        float scaledSinAgeInTicks = 0.13f * sinAgeInTicks;
        this.body.setRotX(this.lerpTo(0.1f, this.body.getRotX(), headPitch * ((float)Math.PI / 180) + scaledSinAgeInTicks));
        this.head.setRotX(-scaledSinAgeInTicks * 1.8f);
        this.topGills.setRotX(this.lerpTo(this.topGills.getRotX(), -0.5f * sinAgeInTicks - 0.8f));
        this.leftGills.setRotY(this.lerpTo(this.leftGills.getRotY(), 0.3f * sinAgeInTicks + 0.9f));
        this.rightGills.setRotY(this.lerpTo(this.rightGills.getRotY(), -this.leftGills.getRotY()));
        this.tail.setRotY(this.lerpTo(this.tail.getRotY(), 0.3f * Mth.m_14089_((float)(scaledAgeInTicks * 0.9f))));
        this.lerpPart(this.leftHindLeg, -1.8849558f, -0.4f * sinAgeInTicks, 1.5707964f);
        this.lerpPart(this.leftFrontLeg, -1.8849558f, -0.2f * cosAgeInTicks - 0.1f, 1.5707964f);
        this.applyMirrorLegRotations();
        this.head.setRotY(this.lerpTo(this.head.getRotY(), 0.0f));
        this.head.setRotZ(this.lerpTo(this.head.getRotZ(), 0.0f));
    }

    protected void setupPlayDeadAnimation(float netHeadYaw) {
        this.lerpPart(this.leftHindLeg, 1.4137167f, 1.0995574f, 0.7853982f);
        this.lerpPart(this.leftFrontLeg, 0.7853982f, 2.042035f, 0.0f);
        this.body.setRotX(this.lerpTo(this.body.getRotX(), -0.15f));
        this.body.setRotZ(this.lerpTo(this.body.getRotZ(), 0.35f));
        this.applyMirrorLegRotations();
        this.body.setRotY(this.lerpTo(this.body.getRotY(), netHeadYaw * ((float)Math.PI / 180)));
        this.head.setRotX(this.lerpTo(this.head.getRotX(), 0.0f));
        this.head.setRotY(this.lerpTo(this.head.getRotY(), 0.0f));
        this.head.setRotZ(this.lerpTo(this.head.getRotZ(), 0.0f));
        this.tail.setRotY(this.lerpTo(this.tail.getRotY(), 0.0f));
        this.lerpPart(this.topGills, 0.0f, 0.0f, 0.0f);
        this.lerpPart(this.leftGills, 0.0f, 0.0f, 0.0f);
        this.lerpPart(this.rightGills, 0.0f, 0.0f, 0.0f);
    }

    protected void applyMirrorLegRotations() {
        this.lerpPart(this.rightHindLeg, this.leftHindLeg.getRotX(), -this.leftHindLeg.getRotY(), -this.leftHindLeg.getRotZ());
        this.lerpPart(this.rightFrontLeg, this.leftFrontLeg.getRotX(), -this.leftFrontLeg.getRotY(), -this.leftFrontLeg.getRotZ());
    }
}

