/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.client.menu.ITabProvider;
import axolootl.client.menu.widget.TabButton;
import axolootl.client.menu.widget.TabGroupButton;
import axolootl.menu.AbstractControllerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractTabScreen<T extends AbstractControllerMenu>
extends AbstractContainerScreen<T>
implements ITabProvider {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("axolootl", "textures/gui/aquarium/background.png");
    public static final ResourceLocation SLOTS = new ResourceLocation("axolootl", "textures/gui/aquarium/slots.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("axolootl", "textures/gui/aquarium/widgets.png");
    public static final int WIDTH = 220;
    public static final int HEIGHT = 222;
    protected List<TabButton> tabButtons = new ArrayList<TabButton>();
    protected List<TabGroupButton> tabGroupButtons = new ArrayList<TabGroupButton>();
    protected int tab;
    protected int tabGroup;

    public AbstractTabScreen(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 220;
        this.f_97727_ = 222;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 30;
        this.tab = ((AbstractControllerMenu)this.m_6262_()).getTab();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (((AbstractControllerMenu)this.m_6262_()).getController().isEmpty()) {
            this.m_7379_();
            return;
        }
        ControllerBlockEntity controller = ((AbstractControllerMenu)this.m_6262_()).getController().get();
        this.f_97736_ = this.calculateTopPos(this);
        this.tabButtons.clear();
        this.tabButtons.addAll(this.initTabs(this));
        this.tabGroupButtons.clear();
        this.tabGroupButtons.addAll(this.initTabGroups(this));
        this.setTab(((AbstractControllerMenu)this.m_6262_()).getTab());
        this.setTabGroup(this.calculateTabGroup(this.tab));
    }

    protected void renderBgTexture(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 220, 222);
    }

    protected void renderPlayerSlots(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)SLOTS);
        this.m_93228_(poseStack, this.f_97735_ + 30 - 1, this.f_97736_ + 140 - 1, 29, 139, 162, 76);
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_7333_(pPoseStack);
        RenderSystem.m_69461_();
        this.renderBgTexture(pPoseStack, pPartialTick, pMouseX, pMouseY);
        if (((AbstractControllerMenu)this.m_6262_()).hasPlayerSlots()) {
            this.renderPlayerSlots(pPoseStack, pPartialTick, pMouseX, pMouseY);
        }
    }

    public void m_86412_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_86412_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        this.f_96547_.m_92889_(pPoseStack, this.m_96636_(), (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        if (((AbstractControllerMenu)this.m_6262_()).hasPlayerSlots()) {
            this.f_96547_.m_92889_(pPoseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected int renderWrappedText(PoseStack poseStack, Component component, int x, int y, int width, int color) {
        this.f_96547_.m_92857_((FormattedText)component, x, y, width, color);
        return this.f_96547_.m_239133_((FormattedText)component, width);
    }

    @Override
    public TabButton addTabButton(int x, int y, int index) {
        TabButton button = (TabButton)this.m_142416_((GuiEventListener)new TabButton(this.f_97735_ + x, this.f_97736_ + y, index, this.getMinecraft().m_91291_()));
        button.setSelected(index == this.tab);
        return button;
    }

    @Override
    public TabGroupButton addTabGroupButton(int x, int y, boolean isLeft, Button.OnPress onPress) {
        return (TabGroupButton)this.m_142416_((GuiEventListener)new TabGroupButton(this.f_97735_ + x, this.f_97736_ + y, isLeft, onPress));
    }

    @Override
    public void setTab(int tab) {
        if ((tab = this.validateTab(tab)) == this.tab || ((AbstractControllerMenu)this.m_6262_()).getController().isEmpty() || !AxRegistry.AquariumTabsReg.getSortedTabs().get(tab).isAvailable(((AbstractControllerMenu)this.m_6262_()).getController().get())) {
            return;
        }
        this.tab = tab;
        ((AbstractControllerMenu)this.m_6262_()).setTab(tab);
    }

    @Override
    public int getTab() {
        return this.tab;
    }

    @Override
    public void setTabGroup(int tabGroup) {
        this.tabGroup = this.validateTabGroup(tabGroup);
        ((AbstractControllerMenu)this.m_6262_()).getController().ifPresent(c -> this.onTabGroupUpdated((ControllerBlockEntity)c));
    }

    @Override
    public int getTabGroup() {
        return this.tabGroup;
    }

    @Override
    public List<TabButton> getTabButtons() {
        return this.tabButtons;
    }

    @Override
    public List<TabGroupButton> getTabGroupButtons() {
        return this.tabGroupButtons;
    }

    protected static Component addHoverText(Component message, Component hoverText) {
        return message.m_6881_().m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText)));
    }

    public static Component concat(Collection<Component> components) {
        MutableComponent component = Component.m_237119_();
        MutableComponent newline = Component.m_237113_((String)"\n");
        for (Component c : components) {
            component.m_7360_().add(c);
            component.m_7360_().add(newline);
        }
        if (component.m_7360_().size() > 1) {
            component.m_7360_().remove(component.m_7360_().size() - 1);
        }
        return component;
    }
}

