/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.client.menu.AbstractCyclingScreen;
import axolootl.client.menu.AbstractTabScreen;
import axolootl.client.menu.AxolootlDetailsScreen;
import axolootl.client.menu.widget.ScrollButton;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.menu.AxolootlInspectorMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AxolootlInspectorScreen
extends AbstractCyclingScreen<AxolootlInspectorMenu>
implements ScrollButton.IScrollListener {
    public static final ResourceLocation INSPECTOR_BG = new ResourceLocation("axolootl", "textures/gui/aquarium/axolootl_inspector.png");
    private static final int PROGRESS_X = 101;
    private static final int PROGRESS_Y = 17;
    private static final int PROGRESS_WIDTH = 20;
    private static final int PROGRESS_HEIGHT = 20;
    private static final int ENTRY_X = 8;
    private static final int ENTRY_Y = 42;
    private static final int ENTRY_COUNT_X = 2;
    private static final int ENTRY_COUNT_Y = 4;
    private static final int ENTRY_COUNT = 8;
    private final List<Map.Entry<ResourceKey<AxolootlVariant>, AxolootlVariant>> variants;
    private int scaledProgress;
    private final List<EntryButton> entryButtons;
    private ScrollButton scrollButton;
    private int scrollOffset;
    public static final String PREFIX = "gui.controller_tab.axolootl.axolootl_inspector.";
    private Component progressText = Component.m_237119_();
    private Component emptyResearchText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_inspector.no_research");

    public AxolootlInspectorScreen(AxolootlInspectorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.variants = new ArrayList<Map.Entry<ResourceKey<AxolootlVariant>, AxolootlVariant>>();
        this.entryButtons = new ArrayList<EntryButton>();
    }

    private void calculateSortedVariants() {
        this.variants.clear();
        RegistryAccess access = ((AxolootlInspectorMenu)this.m_6262_()).getInventory().f_35978_.f_19853_.m_8891_();
        HashSet tracked = new HashSet();
        ((AxolootlInspectorMenu)this.m_6262_()).getInventory().f_35978_.getCapability(Axolootl.AXOLOOTL_RESEARCH_CAPABILITY).ifPresent(c -> tracked.addAll(c.getAxolootls()));
        Registry<AxolootlVariant> registry = AxolootlVariant.getRegistry(access);
        for (Map.Entry entry : registry.m_6579_()) {
            if (!tracked.contains(((ResourceKey)entry.getKey()).m_135782_()) || !((AxolootlVariant)entry.getValue()).isEnabled(access)) continue;
            this.variants.add(entry);
        }
        Comparator<Map.Entry> comparator = Comparator.comparing(a -> ((AxolootlVariant)a.getValue()).getDescription().getString());
        this.variants.sort(comparator);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.calculateSortedVariants();
        this.scrollButton = (ScrollButton)this.m_142416_((GuiEventListener)new ScrollButton(this.f_97735_ + 199, this.f_97736_ + 42 + 1, 12, 80, WIDGETS, 244, 0, 12, 15, 15, true, 1.0f / Math.max(1.0f, (float)(this.variants.size() - 8) / 2.0f), this));
        this.m_7522_((GuiEventListener)this.scrollButton);
        this.scrollButton.f_93623_ = this.variants.size() > 8;
        this.entryButtons.clear();
        for (int i = 0; i < 8; ++i) {
            int x = this.f_97735_ + 8 + i % 2 * 92 + 1;
            int y = this.f_97736_ + 42 + i / 2 * 20 + 1;
            Button.OnPress onPress = b -> ((EntryButton)b).openDetails(this.getMinecraft());
            this.entryButtons.add((EntryButton)this.m_142416_((GuiEventListener)new EntryButton(x, y, this.f_96547_, this.f_96542_, onPress)));
        }
        this.updateEntryButtons();
        this.m_181908_();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (((AxolootlInspectorMenu)this.m_6262_()).hasProgress()) {
            this.scaledProgress = Mth.m_14167_((float)(((AxolootlInspectorMenu)this.m_6262_()).getProgress() * 20.0f));
            int progressPercent = Mth.m_14167_((float)(((AxolootlInspectorMenu)this.m_6262_()).getProgress() * 100.0f));
            this.progressText = Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_inspector.progress", (Object[])new Object[]{progressPercent});
        } else if (this.scaledProgress > 0) {
            this.scaledProgress = 0;
            this.progressText = Component.m_237119_();
        }
        if (((AxolootlInspectorMenu)this.m_6262_()).isChanged()) {
            ((AxolootlInspectorMenu)this.m_6262_()).setChanged(false);
            this.m_6575_(this.getMinecraft(), this.f_96543_, this.f_96544_);
        }
    }

    @Override
    protected void renderBgTexture(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        super.renderBgTexture(poseStack, partialTick, mouseX, mouseY);
        RenderSystem.m_157456_((int)0, (ResourceLocation)INSPECTOR_BG);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 220, 222);
        this.renderProgress(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    public void m_86412_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_86412_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.variants.isEmpty()) {
            int textWidth = this.f_96547_.m_92852_((FormattedText)this.emptyResearchText);
            float f = (float)(this.f_97735_ + 8) + (float)(184 - textWidth) / 2.0f;
            float f2 = this.f_97736_ + 42;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92889_(pPoseStack, this.emptyResearchText, f, f2 + (float)(80 - 9) / 2.0f, 0);
        }
        this.renderHoverActions(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void renderProgress(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
        this.m_93228_(poseStack, this.f_97735_ + 101, this.f_97736_ + 17, 74, 50, 20, 20);
        if (this.scaledProgress > 0) {
            this.m_93228_(poseStack, this.f_97735_ + 101, this.f_97736_ + 17, 74, 70, this.scaledProgress, 20);
        }
    }

    private void renderHoverActions(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (((AxolootlInspectorMenu)this.m_6262_()).hasProgress() && this.m_6774_(101, 17, 20, 20, mouseX, mouseY)) {
            this.m_96602_(poseStack, this.progressText, mouseX, mouseY);
        }
    }

    private void updateEntryButtons() {
        RegistryAccess access = ((AxolootlInspectorMenu)this.m_6262_()).getInventory().f_35978_.f_19853_.m_8891_();
        int n = this.entryButtons.size();
        for (int i = 0; i < n; ++i) {
            EntryButton button = this.entryButtons.get(i);
            int index = i + this.scrollOffset * 2;
            if (index < 0 || index >= this.variants.size()) {
                button.f_93624_ = false;
                continue;
            }
            button.f_93624_ = true;
            button.update(this.variants.get(index), access);
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.m_6774_(8, 42, 184, 80, pMouseX, pMouseY)) {
            return this.scrollButton.m_6050_(pMouseX, pMouseY, pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrollButton != null && this.scrollButton.isDragging()) {
            this.scrollButton.m_7212_(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public void onScroll(ScrollButton button, float percent) {
        this.scrollOffset = Math.round(Math.max(0.0f, percent * Math.max(0.0f, (float)Mth.m_14167_((float)((float)(this.variants.size() - 8) / 2.0f)))));
        this.updateEntryButtons();
    }

    public static class EntryButton
    extends ImageButton {
        public static final int WIDTH = 92;
        public static final int HEIGHT = 20;
        private Font font;
        private ItemRenderer itemRenderer;
        private ResourceLocation key;
        private AxolootlVariant entry;
        private ItemStack icon;
        private List<Component> tooltips = new ArrayList<Component>();

        public EntryButton(int pX, int pY, Font font, ItemRenderer itemRenderer, Button.OnPress pOnPress) {
            super(pX, pY, 92, 20, 137, 104, 20, AbstractTabScreen.WIDGETS, 256, 256, pOnPress, (Component)Component.m_237119_());
            this.key = new ResourceLocation("empty");
            this.entry = AxolootlVariant.EMPTY;
            this.font = font;
            this.itemRenderer = itemRenderer;
            this.icon = new ItemStack((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get());
        }

        public ResourceLocation getKey() {
            return this.key;
        }

        public AxolootlVariant getEntry() {
            return this.entry;
        }

        public List<Component> getTooltips() {
            return this.tooltips;
        }

        public void update(Map.Entry<ResourceKey<AxolootlVariant>, AxolootlVariant> entry, RegistryAccess access) {
            this.key = entry.getKey().m_135782_();
            this.entry = entry.getValue();
            String axolootlName = StringUtil.m_144998_((String)entry.getValue().getDescription().getString(), (int)12, (boolean)true);
            this.m_93666_((Component)Component.m_237113_((String)axolootlName));
            ResourceLocation id = entry.getValue().getRegistryName(access);
            this.icon.m_41784_().m_128359_("Axolootl", id.toString());
            this.tooltips.clear();
            this.tooltips.add(entry.getValue().getDescription());
            this.tooltips.add((Component)Component.m_237110_((String)"entity.axolootl.axolootl.tier", (Object[])new Object[]{entry.getValue().getTierDescription()}).m_130940_(ChatFormatting.GRAY));
            this.m_257544_(Tooltip.m_257550_((Component)AbstractTabScreen.concat(this.tooltips)));
        }

        public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_6303_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            this.itemRenderer.m_115123_(this.icon, this.m_252754_() + 1, this.m_252907_() + (this.f_93619_ - 16) / 2);
            Component component = this.m_6035_();
            float f = this.m_252754_() + 16 + 3;
            float f2 = this.m_252907_();
            Objects.requireNonNull(this.font);
            this.font.m_92889_(pPoseStack, component, f, f2 + (float)(this.f_93619_ - 9) / 2.0f, 0);
        }

        public void openDetails(Minecraft minecraft) {
            if (AxolootlVariant.EMPTY.equals(this.entry)) {
                return;
            }
            if (null == minecraft.f_91073_ || null == minecraft.f_91074_) {
                return;
            }
            if (!AxolootlDetailsScreen.canOpenDetails((Player)minecraft.f_91074_, this.key)) {
                return;
            }
            AxolootlDetailsScreen.openDetails(minecraft, minecraft.f_91073_.m_8891_(), this.key, this.entry, this.icon);
        }
    }
}

