/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.client.menu.AbstractTabScreen;
import axolootl.client.menu.widget.ScrollButton;
import axolootl.data.aquarium_modifier.AquariumModifier;
import axolootl.data.aquarium_modifier.ModifierSettings;
import axolootl.menu.ControllerMenu;
import axolootl.util.BreedStatus;
import axolootl.util.FeedStatus;
import axolootl.util.TankMultiblock;
import axolootl.util.TankStatus;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;

public class ControllerScreen
extends AbstractTabScreen<ControllerMenu>
implements ScrollButton.IScrollListener {
    public static final ResourceLocation CONTROLLER_BG = new ResourceLocation("axolootl", "textures/gui/aquarium/controller.png");
    private static final int TEXT_X = 9;
    private static final int TEXT_Y = 17;
    private static final int TEXT_LINE_SPACING = 4;
    private static final int ENTRY_X = 7;
    private static final int ENTRY_Y = 105;
    private static final int ENTRY_COUNT_X = 1;
    private static final int ENTRY_COUNT_Y = 6;
    private static final int ENTRY_COUNT = 6;
    private final List<EntryButton> entryButtons;
    private ScrollButton scrollButton;
    private ActivateButton activateButton;
    private int scrollOffset;
    private static final int PROCESSING_TIMER = 80;
    private List<ModifierData> modifierDataList = new ArrayList<ModifierData>();
    private boolean hasTank;
    private int processingTimer;
    public static final String PREFIX = "gui.controller_tab.axolootl.controller.";
    private Component tankSizeText;
    private Component tankStatusText;
    private Component feedStatusText;
    private Component breedStatusText;
    private Component axolootlCapacityText;
    private Component modifierCountText;

    public ControllerScreen(ControllerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, ControllerScreen.addHoverText(pTitle, (Component)Component.m_237113_((String)("(" + pMenu.getBlockPos().m_123344_() + ")"))));
        this.entryButtons = new ArrayList<EntryButton>();
        this.tankSizeText = Component.m_237119_();
        this.tankStatusText = Component.m_237119_();
        this.feedStatusText = Component.m_237119_();
        this.breedStatusText = Component.m_237119_();
        this.axolootlCapacityText = Component.m_237119_();
        this.modifierCountText = Component.m_237119_();
        this.hasTank = pMenu.getController().isPresent() && pMenu.getController().get().hasTank();
    }

    public static Component toAdditivePercentage(double value, ChatFormatting color) {
        return Component.m_237113_((String)ControllerScreen.toAdditivePercentage(value)).m_130940_(color);
    }

    public static String toAdditivePercentage(double value) {
        String sign = value < 0.0 ? "-" : "+";
        String sValue = String.format("%.8f", Math.abs(value) * 100.0).replaceAll("0*$", "").replaceAll("\\.$", "");
        return sign + sValue + "%";
    }

    private void updateModifierCountMap() {
        if (((ControllerMenu)this.m_6262_()).getController().isEmpty() || !this.hasTank) {
            return;
        }
        RegistryAccess access = ((ControllerMenu)this.m_6262_()).getInventory().f_35978_.f_19853_.m_8891_();
        ControllerBlockEntity controller = ((ControllerMenu)this.m_6262_()).getController().get();
        Map<BlockPos, AquariumModifier> modifierMap = controller.resolveModifiers(((ControllerMenu)this.m_6262_()).getInventory().f_35978_.f_19853_.m_8891_());
        HashMap<ResourceLocation, ModifierData> dataMap = new HashMap<ResourceLocation, ModifierData>();
        for (Map.Entry entry : AquariumModifier.getRegistry(access).m_6579_()) {
            dataMap.put(((ResourceKey)entry.getKey()).m_135782_(), new ModifierData(access, ((ResourceKey)entry.getKey()).m_135782_(), (AquariumModifier)entry.getValue()));
        }
        for (Map.Entry entry : modifierMap.entrySet()) {
            ResourceLocation id = ((AquariumModifier)entry.getValue()).getRegistryName(access);
            boolean active = controller.activePredicate.test((BlockPos)entry.getKey(), (AquariumModifier)entry.getValue());
            ((ModifierData)dataMap.get(id)).addCount(active);
        }
        this.modifierDataList.clear();
        this.modifierDataList.addAll(dataMap.values());
        Comparator<ModifierData> comparator = Comparator.comparing(o -> o.getCount() <= 0, Boolean::compareTo);
        comparator = comparator.thenComparing(o -> o.getModifier().getDescription().getString());
        this.modifierDataList.sort(comparator);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.updateModifierCountMap();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.m_96636_())) / 2;
        this.scrollButton = (ScrollButton)this.m_142416_((GuiEventListener)new ScrollButton(this.f_97735_ + 200, this.f_97736_ + 106, 12, 109, WIDGETS, 244, 0, 12, 15, 15, true, 1.0f / (float)Math.max(1, this.modifierDataList.size() / 1), this));
        this.m_7522_((GuiEventListener)this.scrollButton);
        this.scrollButton.f_93623_ = this.modifierDataList.size() > 6;
        Button.OnPress activateOnPress = b -> {
            ((ActivateButton)b).setActive(false);
            ((ControllerMenu)this.m_6262_()).activate();
            this.processingTimer = 80;
        };
        this.activateButton = (ActivateButton)this.m_142416_((GuiEventListener)new ActivateButton((this.f_96543_ - 92) / 2, 90, this.f_96547_, activateOnPress));
        this.entryButtons.clear();
        for (int i = 0; i < 6; ++i) {
            int x = this.f_97735_ + 1 + 7 + i % 1 * 186;
            int y = this.f_97736_ + 1 + 105 + i / 1 * 18;
            this.entryButtons.add((EntryButton)this.m_142416_((GuiEventListener)new EntryButton(x, y, this.f_96547_, b -> {})));
        }
        this.updateEntryButtons();
        this.m_181908_();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (((ControllerMenu)this.m_6262_()).getController().isEmpty()) {
            return;
        }
        ControllerBlockEntity controller = ((ControllerMenu)this.m_6262_()).getController().get();
        if (this.processingTimer > 0) {
            if (--this.processingTimer <= 0) {
                this.activateButton.setActive(true);
                this.hasTank = controller.hasTank();
                this.m_6575_(this.getMinecraft(), this.f_96543_, this.f_96544_);
            }
            return;
        }
        this.hasTank = controller.hasTank();
        this.activateButton.f_93624_ = !this.hasTank;
        this.scrollButton.f_93624_ = this.hasTank;
        TankStatus tankStatus = controller.getTankStatus();
        BreedStatus breedStatus = controller.getBreedStatus();
        FeedStatus feedStatus = controller.getFeedStatus();
        long generateTimeRemaining = controller.estimateRemainingResourceGenerationTime();
        MutableComponent tankStatusTooltip = tankStatus.getDescriptionSubtext().m_6881_();
        if (generateTimeRemaining >= 0L) {
            String sTimeRemaining = String.format("%.1f", (double)generateTimeRemaining / 20.0);
            tankStatusTooltip.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"gui.controller_tab.axolootl.controller.status.seconds_remaining.generate_resources", (Object[])new Object[]{sTimeRemaining}).m_130940_(ChatFormatting.GRAY));
        } else {
            tankStatusTooltip.m_130940_(ChatFormatting.RED);
        }
        if (tankStatus == TankStatus.MISSING_MODIFIERS) {
            tankStatusTooltip.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"gui.controller_tab.axolootl.controller.mandatory_modifiers").m_130940_(ChatFormatting.RESET));
            for (TagKey tagKey : AxRegistry.AquariumModifiersReg.getMandatoryAquariumModifiers(this.getMinecraft().f_91073_.m_8891_())) {
                tankStatusTooltip.m_130946_("\n").m_7220_((Component)Component.m_237113_((String)("#" + tagKey.f_203868_().toString())).m_130940_(ChatFormatting.GRAY));
            }
        }
        this.tankStatusText = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.tank_status", (Object[])new Object[]{tankStatus.getDescription(), Math.round(controller.getGenerationSpeed() * 100.0)}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tankStatusTooltip)));
        long feedTimeRemaining = controller.estimateRemainingFeedTime();
        MutableComponent feedStatusTooltip = feedStatus.getDescriptionSubtext().m_6881_();
        if (feedTimeRemaining >= 0L) {
            String sTimeRemaining = String.format("%.1f", (double)feedTimeRemaining / 20.0);
            feedStatusTooltip.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"gui.controller_tab.axolootl.controller.status.seconds_remaining.feed", (Object[])new Object[]{sTimeRemaining}).m_130940_(ChatFormatting.GRAY));
        } else {
            feedStatusTooltip.m_130940_(ChatFormatting.RED);
        }
        this.feedStatusText = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.feed_status", (Object[])new Object[]{feedStatus.getDescription(), Math.round(controller.getFeedSpeed() * 100.0)}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)feedStatusTooltip)));
        long breedTimeRemaining = controller.estimateRemainingBreedTime();
        MutableComponent breedStatusTooltip = breedStatus.getDescriptionSubtext().m_6881_();
        if (breedTimeRemaining >= 0L) {
            String sTimeRemaining = String.format("%.1f", (double)breedTimeRemaining / 20.0);
            breedStatusTooltip.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"gui.controller_tab.axolootl.controller.status.seconds_remaining.breed", (Object[])new Object[]{sTimeRemaining}).m_130940_(ChatFormatting.GRAY));
        } else {
            breedStatusTooltip.m_130940_(ChatFormatting.RED);
        }
        this.breedStatusText = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.breed_status", (Object[])new Object[]{breedStatus.getDescription(), Math.round(controller.getBreedSpeed() * 100.0)}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)breedStatusTooltip)));
        Optional<TankMultiblock.Size> size = controller.getSize();
        if (size.isEmpty()) {
            this.tankSizeText = Component.m_237115_((String)"gui.controller_tab.axolootl.controller.size.invalid");
            this.axolootlCapacityText = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.capacity.multiple", (Object[])new Object[]{0});
            this.modifierCountText = Component.m_237115_((String)"gui.controller_tab.axolootl.controller.modifier_count.invalid");
        } else {
            Vec3i dim = size.get().getFullDimensions();
            MutableComponent tankSizeTooltip = Component.m_237110_((String)"gui.controller_tab.axolootl.fluid_interface.volume", (Object[])new Object[]{size.get().getInnerVolume()});
            this.tankSizeText = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.size", (Object[])new Object[]{dim.m_123341_(), dim.m_123342_(), dim.m_123343_()}).m_130938_(arg_0 -> ControllerScreen.lambda$containerTick$7((Component)tankSizeTooltip, arg_0));
            int capacity = ControllerBlockEntity.calculateMaxCapacity(size.get());
            String volumeFactor = "%.2f".formatted(Axolootl.CONFIG.TANK_CAPACITY_VOLUME_FACTOR.get()).replaceAll("0*$", "").replaceAll("\\.$", "");
            MutableComponent axolootlCapacityTooltip = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.capacity.description", (Object[])new Object[]{volumeFactor});
            this.axolootlCapacityText = Component.m_237110_((String)("gui.controller_tab.axolootl.controller.capacity." + (capacity == 1 ? "single" : "multiple")), (Object[])new Object[]{capacity}).m_130938_(arg_0 -> ControllerScreen.lambda$containerTick$8((Component)axolootlCapacityTooltip, arg_0));
            int modifierCount = controller.getAquariumModifiers().size();
            int activeCount = controller.getActiveAquariumModifiers().size();
            MutableComponent modifierCountTooltip = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.modifier_count.description", (Object[])new Object[]{activeCount, modifierCount});
            this.modifierCountText = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.modifier_count", (Object[])new Object[]{Component.m_237113_((String)("" + activeCount)).m_130940_(modifierCount == activeCount ? ChatFormatting.RESET : ChatFormatting.DARK_RED), modifierCount}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)modifierCountTooltip)));
        }
        this.updateEntryButtons();
    }

    @Override
    protected void renderBgTexture(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 220, 222);
        if (this.hasTank) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)CONTROLLER_BG);
            this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 220, 222);
        }
    }

    @Override
    public void m_86412_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_86412_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderDetails(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderHoverActions(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void renderDetails(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int x = this.f_97735_ + 9;
        int y = this.f_97736_ + 17;
        Objects.requireNonNull(this.f_96547_);
        int textDeltaY = 9 + 4;
        this.f_96547_.m_92889_(poseStack, this.tankStatusText, (float)x, (float)y, 0);
        this.f_96547_.m_92889_(poseStack, this.feedStatusText, (float)x, (float)(y += textDeltaY), 0);
        this.f_96547_.m_92889_(poseStack, this.breedStatusText, (float)x, (float)(y += textDeltaY), 0);
        if (!this.hasTank) {
            return;
        }
        this.f_96547_.m_92889_(poseStack, this.tankSizeText, (float)x, (float)(y += textDeltaY * 2), 0);
        this.f_96547_.m_92889_(poseStack, this.axolootlCapacityText, (float)x, (float)(y += textDeltaY), 0);
        this.f_96547_.m_92889_(poseStack, this.modifierCountText, (float)x, (float)(y += textDeltaY), 0);
    }

    private void renderHoverActions(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int n = this.f_96547_.m_92852_((FormattedText)this.m_96636_());
        Objects.requireNonNull(this.f_96547_);
        if (this.m_6774_(this.f_97728_, this.f_97729_, n, 9, mouseX, mouseY)) {
            this.m_96570_(poseStack, this.m_96636_().m_7383_(), mouseX, mouseY);
        }
        int x = 9;
        int y = 17;
        Objects.requireNonNull(this.f_96547_);
        int textDeltaY = 9 + 4;
        int n2 = this.f_96547_.m_92852_((FormattedText)this.tankStatusText);
        Objects.requireNonNull(this.f_96547_);
        if (this.m_6774_(x, y, n2, 9, mouseX, mouseY)) {
            this.m_96570_(poseStack, this.tankStatusText.m_7383_(), mouseX, mouseY);
        }
        int n3 = this.f_96547_.m_92852_((FormattedText)this.feedStatusText);
        Objects.requireNonNull(this.f_96547_);
        if (this.m_6774_(x, y += textDeltaY, n3, 9, mouseX, mouseY)) {
            this.m_96570_(poseStack, this.feedStatusText.m_7383_(), mouseX, mouseY);
        }
        int n4 = this.f_96547_.m_92852_((FormattedText)this.breedStatusText);
        Objects.requireNonNull(this.f_96547_);
        if (this.m_6774_(x, y += textDeltaY, n4, 9, mouseX, mouseY)) {
            this.m_96570_(poseStack, this.breedStatusText.m_7383_(), mouseX, mouseY);
        }
        if (!this.hasTank) {
            return;
        }
        int n5 = this.f_96547_.m_92852_((FormattedText)this.tankSizeText);
        Objects.requireNonNull(this.f_96547_);
        if (this.m_6774_(x, y += textDeltaY * 2, n5, 9, mouseX, mouseY)) {
            this.m_96570_(poseStack, this.tankSizeText.m_7383_(), mouseX, mouseY);
        }
        int n6 = this.f_96547_.m_92852_((FormattedText)this.axolootlCapacityText);
        Objects.requireNonNull(this.f_96547_);
        if (this.m_6774_(x, y += textDeltaY, n6, 9, mouseX, mouseY)) {
            this.m_96570_(poseStack, this.axolootlCapacityText.m_7383_(), mouseX, mouseY);
        }
        int n7 = this.f_96547_.m_92852_((FormattedText)this.modifierCountText);
        Objects.requireNonNull(this.f_96547_);
        if (this.m_6774_(x, y += textDeltaY, n7, 9, mouseX, mouseY)) {
            this.m_96570_(poseStack, this.modifierCountText.m_7383_(), mouseX, mouseY);
        }
    }

    private void updateEntryButtons() {
        int n = this.entryButtons.size();
        for (int i = 0; i < n; ++i) {
            EntryButton button = this.entryButtons.get(i);
            int index = i + this.scrollOffset * 1;
            if (!this.hasTank || index < 0 || index >= this.modifierDataList.size()) {
                button.f_93623_ = false;
                button.f_93624_ = false;
                continue;
            }
            button.f_93624_ = true;
            button.update(this.modifierDataList.get(index), ((ControllerMenu)this.m_6262_()).getInventory().f_35978_.f_19853_.m_8891_());
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.m_6774_(7, 105, 186, 108, pMouseX, pMouseY)) {
            return this.scrollButton.m_6050_(pMouseX, pMouseY, pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrollButton != null && this.scrollButton.isDragging()) {
            this.scrollButton.m_7212_(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public void onScroll(ScrollButton button, float percent) {
        this.scrollOffset = Mth.m_14143_((float)Math.max(0.0f, percent * (float)Math.max(0, this.modifierDataList.size() - 6)));
        this.updateEntryButtons();
    }

    private static /* synthetic */ Style lambda$containerTick$8(Component axolootlCapacityTooltip, Style a) {
        return a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)axolootlCapacityTooltip));
    }

    private static /* synthetic */ Style lambda$containerTick$7(Component tankSizeTooltip, Style a) {
        return a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tankSizeTooltip));
    }

    private static class ModifierData {
        private final ResourceLocation id;
        private final List<ResourceLocation> tags;
        private final AquariumModifier modifier;
        private int activeCount;
        private int count;

        private ModifierData(RegistryAccess access, ResourceLocation id, AquariumModifier modifier) {
            this(id, modifier, modifier.getReverseTags(access).stream().map(TagKey::f_203868_).toList());
        }

        private ModifierData(ResourceLocation id, AquariumModifier modifier, List<ResourceLocation> tags) {
            this.id = id;
            this.modifier = modifier;
            this.tags = tags;
        }

        private void addCount(boolean active) {
            if (active) {
                ++this.activeCount;
            }
            ++this.count;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public AquariumModifier getModifier() {
            return this.modifier;
        }

        public int getActiveCount() {
            return this.activeCount;
        }

        public int getCount() {
            return this.count;
        }

        public List<ResourceLocation> getTags() {
            return this.tags;
        }
    }

    private static class ActivateButton
    extends ImageButton {
        private static final int WIDTH = 92;
        private static final int HEIGHT = 18;
        private final Font font;
        private final Component message;
        private final Component messagePending;

        public ActivateButton(int pX, int pY, Font font, Button.OnPress pOnPress) {
            super(pX, pY, 92, 18, 137, 50, 18, AbstractTabScreen.WIDGETS, 256, 256, pOnPress, (Component)Component.m_237115_((String)"gui.controller_tab.axolootl.controller.activate"));
            this.font = font;
            this.message = this.m_6035_();
            this.messagePending = Component.m_237115_((String)"gui.controller_tab.axolootl.controller.activate.pending");
        }

        public void setActive(boolean active) {
            this.f_93623_ = active;
            if (active) {
                this.m_93666_(this.message);
            } else {
                this.m_93666_(this.messagePending);
            }
        }

        public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_6303_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            Component component = this.m_6035_();
            float f = (float)this.m_252754_() + (float)(this.f_93618_ - this.font.m_92852_((FormattedText)this.m_6035_())) / 2.0f;
            float f2 = this.m_252907_();
            Objects.requireNonNull(this.font);
            this.font.m_92889_(pPoseStack, component, f, f2 + (float)(this.f_93619_ - 9) / 2.0f, 0);
        }
    }

    private static class EntryButton
    extends ImageButton {
        private static final int WIDTH = 186;
        private static final int HEIGHT = 18;
        private final Font font;
        private ModifierData entry;
        private boolean hasInactive;
        private Component showBonuses;
        private Component showConditions;
        private Component description;
        private Component countText;
        private List<Component> nameTooltips = new ArrayList<Component>();
        private List<Component> countTooltips = new ArrayList<Component>();
        private List<Component> bonusesTooltips = new ArrayList<Component>();
        private List<Component> conditionsTooltips = new ArrayList<Component>();

        public EntryButton(int pX, int pY, Font font, Button.OnPress pOnPress) {
            super(pX, pY, 186, 18, 0, 234, 0, AbstractTabScreen.WIDGETS, 256, 256, pOnPress, (Component)Component.m_237119_());
            this.showBonuses = Component.m_237115_((String)"gui.controller_tab.axolootl.controller.entry.bonuses").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.controller_tab.axolootl.controller.entry.show_bonuses").m_130940_(ChatFormatting.YELLOW));
            this.showConditions = Component.m_237115_((String)"gui.controller_tab.axolootl.controller.entry.condition").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.controller_tab.axolootl.controller.entry.show_condition").m_130940_(ChatFormatting.YELLOW));
            this.font = font;
            this.entry = new ModifierData(new ResourceLocation("empty"), AquariumModifier.EMPTY, (List<ResourceLocation>)ImmutableList.of());
            this.description = Component.m_237119_();
        }

        public void update(ModifierData entry, RegistryAccess registryAccess) {
            this.entry = entry;
            ChatFormatting existsColor = entry.getCount() <= 0 ? ChatFormatting.DARK_GRAY : ChatFormatting.RESET;
            MutableComponent activeText = Component.m_237113_((String)("" + entry.getActiveCount())).m_130940_(this.hasInactive ? ChatFormatting.DARK_RED : ChatFormatting.RESET);
            this.countText = Component.m_237110_((String)"gui.controller_tab.axolootl.controller.entry.count", (Object[])new Object[]{activeText, entry.getCount()}).m_130940_(existsColor);
            String sDescription = entry.getModifier().getDescription().getString();
            this.description = Component.m_237113_((String)StringUtil.m_144998_((String)sDescription, (int)(38 - this.font.m_92852_((FormattedText)this.countText) / 6), (boolean)true)).m_130948_(entry.getModifier().getDescription().m_7383_()).m_130940_(existsColor);
            this.hasInactive = entry.getCount() > entry.getActiveCount();
            this.nameTooltips.clear();
            this.nameTooltips.add(entry.getModifier().getDescription());
            this.nameTooltips.add((Component)Component.m_237113_((String)entry.getId().toString()).m_130940_(ChatFormatting.GRAY));
            if (!this.entry.getTags().isEmpty()) {
                this.nameTooltips.add((Component)Component.m_237119_());
                for (ResourceLocation tagKey : this.entry.getTags()) {
                    this.nameTooltips.add((Component)Component.m_237113_((String)("#" + tagKey.toString())).m_130940_(ChatFormatting.GRAY));
                }
            }
            this.countTooltips.clear();
            MutableComponent activeCountText = Component.m_237113_((String)("" + entry.getActiveCount())).m_130940_(this.hasInactive ? ChatFormatting.RED : ChatFormatting.RESET);
            if (entry.getActiveCount() == 1) {
                this.countTooltips.add((Component)Component.m_237110_((String)"gui.controller_tab.axolootl.controller.entry.active.single", (Object[])new Object[]{activeCountText}));
            } else {
                this.countTooltips.add((Component)Component.m_237110_((String)"gui.controller_tab.axolootl.controller.entry.active.multiple", (Object[])new Object[]{activeCountText}));
            }
            this.bonusesTooltips.clear();
            this.bonusesTooltips.addAll(EntryButton.createBonusesTooltips(entry.getModifier().getSettings(), entry.getActiveCount()));
            this.conditionsTooltips.clear();
            this.conditionsTooltips.add((Component)Component.m_237115_((String)"gui.controller_tab.axolootl.controller.entry.condition").m_130940_(ChatFormatting.GOLD));
            if (entry.getModifier().getSettings().getEnergyCost() > 0) {
                this.conditionsTooltips.add((Component)EntryButton.createBonusTooltip("axolootl.modifier_settings.energy_cost", entry.getActiveCount(), Component.m_237113_((String)("" + entry.getModifier().getSettings().getEnergyCost())).m_130940_(ChatFormatting.RED), Component.m_237113_((String)("" + entry.getModifier().getSettings().getEnergyCost() * entry.getActiveCount())).m_130940_(ChatFormatting.RED)));
            }
            this.conditionsTooltips.addAll(entry.getModifier().getCondition().getDescription(registryAccess));
        }

        public List<Component> getTooltips(PoseStack poseStack, int mouseX, int mouseY) {
            boolean advancedTooltips = Minecraft.m_91087_().f_91066_.f_92125_;
            if (mouseX < this.m_252754_() + this.font.m_92852_((FormattedText)this.description)) {
                return this.nameTooltips;
            }
            ArrayList<Component> list = new ArrayList<Component>(this.countTooltips);
            if (Screen.m_96638_() || advancedTooltips) {
                list.addAll(this.bonusesTooltips);
            } else {
                list.add(this.showBonuses);
            }
            if (this.hasInactive || Screen.m_96637_() || advancedTooltips) {
                list.addAll(this.conditionsTooltips);
            } else {
                list.add(this.showConditions);
            }
            return list;
        }

        public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            int messageWidth = this.font.m_92852_((FormattedText)this.countText);
            super.m_6303_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            float f = this.m_252907_();
            Objects.requireNonNull(this.font);
            float drawY = f + (float)(this.f_93619_ - 9) / 2.0f;
            this.font.m_92889_(pPoseStack, this.description, (float)(this.m_252754_() + 4), drawY, 0);
            this.font.m_92889_(pPoseStack, this.countText, (float)(this.m_252754_() + (this.f_93618_ - messageWidth) - 4), drawY, 0);
            if (this.m_198029_()) {
                this.m_257544_(Tooltip.m_257550_((Component)AbstractTabScreen.concat(this.getTooltips(pPoseStack, pMouseX, pMouseY))));
            }
        }

        private static List<Component> createBonusesTooltips(ModifierSettings modifier, int activeCount) {
            ImmutableList.Builder builder = ImmutableList.builder();
            String PREFIX = "axolootl.modifier_settings.";
            if (Math.abs(modifier.getGenerationSpeed()) > 1.0E-8) {
                builder.add((Object)EntryButton.createBonusTooltip("axolootl.modifier_settings.generation_speed", activeCount, ControllerScreen.toAdditivePercentage(modifier.getGenerationSpeed(), ChatFormatting.GREEN), ControllerScreen.toAdditivePercentage(modifier.getGenerationSpeed() * (double)activeCount, ChatFormatting.GREEN)));
            }
            if (Math.abs(modifier.getBreedSpeed()) > 1.0E-8) {
                builder.add((Object)EntryButton.createBonusTooltip("axolootl.modifier_settings.breed_speed", activeCount, ControllerScreen.toAdditivePercentage(modifier.getBreedSpeed(), ChatFormatting.LIGHT_PURPLE), ControllerScreen.toAdditivePercentage(modifier.getBreedSpeed() * (double)activeCount, ChatFormatting.LIGHT_PURPLE)));
            }
            if (Math.abs(modifier.getFeedSpeed()) > 1.0E-8) {
                builder.add((Object)EntryButton.createBonusTooltip("axolootl.modifier_settings.feed_speed", activeCount, ControllerScreen.toAdditivePercentage(modifier.getFeedSpeed(), ChatFormatting.YELLOW), ControllerScreen.toAdditivePercentage(modifier.getFeedSpeed() * (double)activeCount, ChatFormatting.YELLOW)));
            }
            if (modifier.getSpreadSpeed() > 1.0E-8) {
                builder.add((Object)EntryButton.createBonusTooltip("axolootl.modifier_settings.spread_speed", activeCount, ControllerScreen.toAdditivePercentage(modifier.getSpreadSpeed(), ChatFormatting.BLUE), ControllerScreen.toAdditivePercentage(modifier.getSpreadSpeed() * (double)activeCount, ChatFormatting.BLUE)));
            }
            if (modifier.isEnableMobResources()) {
                builder.add((Object)Component.m_237115_((String)"axolootl.modifier_settings.enable_mob_resources").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            }
            if (modifier.isEnableMobBreeding()) {
                builder.add((Object)Component.m_237115_((String)"axolootl.modifier_settings.enable_mob_breeding").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            }
            return builder.build();
        }

        private static MutableComponent createBonusTooltip(String key, int activeCount, Object single, Object multiple) {
            if (activeCount > 1) {
                return Component.m_237110_((String)(key + ".multiple"), (Object[])new Object[]{multiple, single});
            }
            return Component.m_237110_((String)(key + ".single"), (Object[])new Object[]{single});
        }
    }
}

