/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.block.entity.ControllerBlockEntity;
import axolootl.block.entity.VoidEnergyStorage;
import axolootl.client.menu.AbstractCyclingScreen;
import axolootl.data.aquarium_modifier.AquariumModifier;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.menu.CyclingMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyInterfaceScreen
extends AbstractCyclingScreen<CyclingMenu> {
    private static final int ENERGY_X = 29;
    private static final int ENERGY_Y = 17;
    private static final int ENERGY_WIDTH = 18;
    private static final int ENERGY_HEIGHT = 108;
    private static final int ENERGY_U = 0;
    private static final int ENERGY_V = 50;
    private static final int ENERGY_MARGIN = 2;
    private static final int TEXT_X = 51;
    private static final int TEXT_Y = 25;
    private static final int TEXT_WIDTH = 162;
    private static final int TEXT_LINE_SPACING = 8;
    private Map<BlockPos, IEnergyStorage> energyStorage = new HashMap<BlockPos, IEnergyStorage>();
    private IEnergyStorage storage;
    private int totalEnergy;
    private float totalEnergyPercent;
    private int totalEnergyHeight;
    private int totalCapacity;
    private int individualEnergy;
    private float individualEnergyPercent;
    private int individualEnergyHeight;
    private int poweredModifiers;
    private int usagePerTick;
    private int poweredAxolootls;
    private int usagePerAxolootl;
    public static final String PREFIX = "gui.controller_tab.axolootl.energy_interface.";
    private Component energyCapacityText;
    private Component energyStorageText;
    private Component individualStorageText;
    private Component poweredModifiersText;
    private Component energyUsagePerTickText;
    private Component poweredAxolootlsText;
    private Component energyUsagePerAxolootlText;

    public EnergyInterfaceScreen(CyclingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        pMenu.getController().ifPresent(c -> this.energyStorage.putAll(c.resolveEnergyStorage(IEnergyStorage::canExtract)));
        this.storage = this.energyStorage.getOrDefault(pMenu.getBlockPos(), VoidEnergyStorage.INSTANCE);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (((CyclingMenu)this.m_6262_()).getController().isEmpty()) {
            return;
        }
        ControllerBlockEntity controller = ((CyclingMenu)this.m_6262_()).getController().get();
        RegistryAccess registryAccess = ((CyclingMenu)this.m_6262_()).getInventory().f_35978_.f_19853_.m_8891_();
        Collection<AquariumModifier> poweredModifierSet = controller.resolveModifiers(registryAccess, (b, a) -> a.getSettings().getEnergyCost() > 0).values();
        this.usagePerTick = 0;
        this.poweredModifiers = poweredModifierSet.size();
        for (AquariumModifier modifier : poweredModifierSet) {
            this.usagePerTick += modifier.getSettings().getEnergyCost();
        }
        List<AxolootlVariant> variantSet = controller.resolveAxolootlVariants(registryAccess).values().stream().filter(a -> a.getEnergyCost() > 0).toList();
        this.usagePerAxolootl = 0;
        this.poweredAxolootls = variantSet.size();
        for (AxolootlVariant variant : variantSet) {
            this.usagePerAxolootl += variant.getEnergyCost();
        }
        this.poweredModifiersText = Component.m_237110_((String)"gui.controller_tab.axolootl.energy_interface.powered_modifier_count", (Object[])new Object[]{this.poweredModifiers}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.controller_tab.axolootl.energy_interface.powered_modifier_count.description"))));
        this.poweredAxolootlsText = Component.m_237110_((String)"gui.controller_tab.axolootl.energy_interface.powered_axolootl_count", (Object[])new Object[]{this.poweredAxolootls}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.controller_tab.axolootl.energy_interface.powered_axolootl_count.description"))));
        this.energyUsagePerTickText = Component.m_237110_((String)"gui.controller_tab.axolootl.energy_interface.tick_usage", (Object[])new Object[]{this.usagePerTick}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.controller_tab.axolootl.energy_interface.tick_usage.description"))));
        this.energyUsagePerAxolootlText = Component.m_237110_((String)"gui.controller_tab.axolootl.energy_interface.axolootl_usage", (Object[])new Object[]{this.usagePerAxolootl}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.controller_tab.axolootl.energy_interface.axolootl_usage.description"))));
        this.m_181908_();
    }

    protected void m_181908_() {
        super.m_181908_();
        this.totalEnergy = 0;
        this.totalCapacity = 0;
        for (IEnergyStorage entry : this.energyStorage.values()) {
            this.totalEnergy += entry.getEnergyStored();
            this.totalCapacity += entry.getMaxEnergyStored();
        }
        this.individualEnergy = this.storage.getEnergyStored();
        this.totalEnergyPercent = (float)this.totalEnergy / (float)this.totalCapacity;
        this.totalEnergyHeight = Mth.m_14143_((float)(this.totalEnergyPercent * 108.0f));
        if (this.totalEnergy > 0) {
            this.totalEnergyHeight = Mth.m_14045_((int)this.totalEnergyHeight, (int)3, (int)106);
        }
        this.individualEnergyPercent = (float)this.storage.getEnergyStored() / (float)this.totalCapacity;
        this.individualEnergyHeight = Mth.m_14143_((float)(this.individualEnergyPercent * 108.0f));
        if (this.storage.getEnergyStored() > 0) {
            this.individualEnergyHeight = Mth.m_14045_((int)this.individualEnergyHeight, (int)3, (int)106);
        }
        this.energyCapacityText = Component.m_237110_((String)"gui.controller_tab.axolootl.energy_interface.energy_capacity", (Object[])new Object[]{this.totalCapacity});
        this.energyStorageText = Component.m_237110_((String)"gui.controller_tab.axolootl.energy_interface.energy_storage", (Object[])new Object[]{this.totalEnergy, this.totalCapacity});
        this.individualStorageText = Component.m_237110_((String)"gui.controller_tab.axolootl.energy_interface.individual_storage", (Object[])new Object[]{this.individualEnergy, this.storage.getMaxEnergyStored()});
    }

    @Override
    public void m_86412_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_86412_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderEnergyBar(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderDetails(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderHoverActions(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void renderEnergyBar(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        int x = this.f_97735_ + 29;
        int y = this.f_97736_ + 17;
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
        this.m_93228_(pPoseStack, x, y, 0, 50, 18, 108);
        this.m_93228_(pPoseStack, x, y + 106 - this.totalEnergyHeight, 18, 50, 18, this.totalEnergyHeight);
        this.m_93228_(pPoseStack, x, y + 106 - this.individualEnergyHeight, 36, 50, 18, this.individualEnergyHeight);
    }

    private void renderDetails(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int x = this.f_97735_ + 51;
        int y = this.f_97736_ + 25;
        y += this.renderWrappedText(poseStack, this.energyStorageText, x, y, 162, 0) + 8;
        y += this.renderWrappedText(poseStack, this.poweredModifiersText, x, y, 162, 0) + 8;
        y += this.renderWrappedText(poseStack, this.energyUsagePerTickText, x, y, 162, 0) + 8;
        y += this.renderWrappedText(poseStack, this.poweredAxolootlsText, x, y, 162, 0) + 8;
        y += this.renderWrappedText(poseStack, this.energyUsagePerAxolootlText, x, y, 162, 0) + 8;
    }

    private void renderHoverActions(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        int x = 51;
        int y = 33 + this.f_96547_.m_239133_((FormattedText)this.energyStorageText, 162);
        int h = this.f_96547_.m_239133_((FormattedText)this.poweredModifiersText, 162);
        if (this.m_6774_(x, y, this.f_96547_.m_92852_((FormattedText)this.poweredModifiersText), h, pMouseX, pMouseY)) {
            this.m_96570_(pPoseStack, this.poweredModifiersText.m_7383_(), pMouseX, pMouseY);
        }
        y += h + 8;
        h = this.f_96547_.m_239133_((FormattedText)this.energyUsagePerTickText, 162);
        if (this.m_6774_(x, y, this.f_96547_.m_92852_((FormattedText)this.energyUsagePerTickText), h, pMouseX, pMouseY)) {
            this.m_96570_(pPoseStack, this.energyUsagePerTickText.m_7383_(), pMouseX, pMouseY);
        }
        y += h + 8;
        h = this.f_96547_.m_239133_((FormattedText)this.poweredAxolootlsText, 162);
        if (this.m_6774_(x, y, this.f_96547_.m_92852_((FormattedText)this.poweredAxolootlsText), h, pMouseX, pMouseY)) {
            this.m_96570_(pPoseStack, this.poweredAxolootlsText.m_7383_(), pMouseX, pMouseY);
        }
        y += h + 8;
        h = this.f_96547_.m_239133_((FormattedText)this.energyUsagePerAxolootlText, 162);
        if (this.m_6774_(x, y, this.f_96547_.m_92852_((FormattedText)this.energyUsagePerAxolootlText), h, pMouseX, pMouseY)) {
            this.m_96570_(pPoseStack, this.energyUsagePerAxolootlText.m_7383_(), pMouseX, pMouseY);
        }
        if (this.m_6774_(x = 29, y = 17, 18, 108 - this.totalEnergyHeight - 1, pMouseX, pMouseY)) {
            this.m_96602_(pPoseStack, this.energyCapacityText, pMouseX, pMouseY);
        }
        if (this.m_6774_(x, y += 108 - this.totalEnergyHeight + 1, 18, this.totalEnergyHeight - this.individualEnergyHeight - 1, pMouseX, pMouseY)) {
            this.m_96602_(pPoseStack, this.energyStorageText, pMouseX, pMouseY);
        }
        if (this.m_6774_(x, y += this.totalEnergyHeight - this.individualEnergyHeight + 1, 18, this.individualEnergyHeight, pMouseX, pMouseY)) {
            this.m_96602_(pPoseStack, this.individualStorageText, pMouseX, pMouseY);
        }
    }
}

