/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu.widget;

import axolootl.client.menu.AbstractTabScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemButton
extends Button {
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    protected final Font font;
    protected final ItemRenderer itemRenderer;
    protected final Function<ItemStack, List<Component>> getTooltipFromItem;
    protected final ResourceLocation texture;
    protected final int textureU;
    protected final int textureV;
    protected final int textureWidth;
    protected final int textureHeight;
    protected boolean drawBackground;
    protected ItemStack item;

    public ItemButton(int pX, int pY, boolean drawBackground, Font font, ItemRenderer itemRenderer, ItemStack item, Function<ItemStack, List<Component>> getTooltipFromItem, Button.OnPress onPress) {
        this(pX, pY, drawBackground, font, itemRenderer, item, getTooltipFromItem, onPress, false);
    }

    public ItemButton(int pX, int pY, boolean drawBackground, Font font, ItemRenderer itemRenderer, ItemStack item, Function<ItemStack, List<Component>> getTooltipFromItem, Button.OnPress onPress, boolean updateTooltip) {
        this(pX, pY, drawBackground, font, itemRenderer, item, getTooltipFromItem, onPress, AbstractTabScreen.SLOTS, 30, 18, 256, 256);
        if (updateTooltip) {
            this.m_257936_();
        }
    }

    protected ItemButton(int pX, int pY, boolean drawBackground, Font font, ItemRenderer itemRenderer, ItemStack item, Function<ItemStack, List<Component>> getTooltipFromItem, Button.OnPress onPress, ResourceLocation texture, int u, int v, int textureWidth, int textureHeight) {
        super(pX, pY, 16, 16, item.m_41786_(), onPress, Button.f_252438_);
        this.drawBackground = drawBackground;
        this.font = font;
        this.itemRenderer = itemRenderer;
        this.item = item;
        this.getTooltipFromItem = getTooltipFromItem;
        this.texture = texture;
        this.textureU = u;
        this.textureV = v;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public List<Component> getTooltips() {
        return this.getTooltipFromItem.apply(this.item);
    }

    public void setItem(ItemStack item) {
        this.item = item;
        this.m_257544_(Tooltip.m_257550_((Component)AbstractTabScreen.concat(this.getTooltips())));
    }

    public void m_257936_() {
        this.m_257544_(Tooltip.m_257550_((Component)AbstractTabScreen.concat(this.getTooltips())));
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.drawBackground) {
            this.renderBackground(pPoseStack, this.m_252754_(), this.m_252907_());
        }
        if (!this.item.m_41619_()) {
            this.renderItem(this.item, this.m_252754_(), this.m_252907_());
        }
    }

    protected void renderBackground(PoseStack poseStack, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_69482_();
        ItemButton.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)this.textureU, (float)this.textureV, (int)16, (int)16, (int)this.textureWidth, (int)this.textureHeight);
    }

    protected void renderItem(ItemStack itemStack, int x, int y) {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_252880_(0.0f, 0.0f, 2000.0f);
        RenderSystem.m_157182_();
        this.itemRenderer.m_115203_(itemStack, x, y);
        this.itemRenderer.m_115169_(this.font, itemStack, x, y);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }
}

