/*
 * Decompiled with CFR 0.152.
 */
package axolootl.command;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.capability.AxolootlResearchCapability;
import axolootl.data.axolootl_variant.AxolootlVariant;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class AxolootlResearchCommand {
    private static final String COMMAND = "axresearch";
    private static final DynamicCommandExceptionType UNKNOWN_VARIANT = new DynamicCommandExceptionType(o -> Component.m_237110_((String)"commands.axresearch.failure.unknown_variant", (Object[])new Object[]{o}));
    private static final DynamicCommandExceptionType INVALID_VARIANT = new DynamicCommandExceptionType(o -> Component.m_237110_((String)"commands.axresearch.failure.invalid_variant", (Object[])new Object[]{o}));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_AXOLOOTL_VARIANT = (context, builder) -> {
        Sets.SetView set = Sets.difference((Set)AxolootlVariant.getRegistry(((CommandSourceStack)context.getSource()).m_5894_()).m_6566_(), AxRegistry.AxolootlVariantsReg.getInvalidEntries());
        return SharedSuggestionProvider.m_82981_(set.stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND).requires(c -> c.m_6761_(2))).then(Commands.m_82127_((String)"grant").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"all").executes(context -> AxolootlResearchCommand.addAll((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_AXOLOOTL_VARIANT).executes(context -> AxolootlResearchCommand.add((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"id"))))))).then(Commands.m_82127_((String)"revoke").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"all").executes(context -> AxolootlResearchCommand.removeAll((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_AXOLOOTL_VARIANT).executes(context -> AxolootlResearchCommand.remove((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"id"))))));
        dispatcher.register(builder);
    }

    private static int add(CommandSourceStack context, Collection<ServerPlayer> targets, ResourceLocation id) throws CommandSyntaxException {
        Registry<AxolootlVariant> registry = AxolootlVariant.getRegistry(context.m_5894_());
        Optional oVariant = registry.m_6612_(id);
        if (oVariant.isEmpty()) {
            throw UNKNOWN_VARIANT.create((Object)id);
        }
        if (!AxRegistry.AxolootlVariantsReg.isValid(id)) {
            throw INVALID_VARIANT.create((Object)id);
        }
        for (ServerPlayer target : targets) {
            target.getCapability(Axolootl.AXOLOOTL_RESEARCH_CAPABILITY).ifPresent(c -> c.addAxolootl(target, id));
        }
        if (targets.size() == 1) {
            context.m_81354_((Component)Component.m_237110_((String)"commands.axresearch.add.single.success", (Object[])new Object[]{id, targets.iterator().next().m_5446_()}), true);
        } else {
            context.m_81354_((Component)Component.m_237110_((String)"commands.axresearch.add.multiple.success", (Object[])new Object[]{id, targets.size()}), true);
        }
        return 1;
    }

    private static int addAll(CommandSourceStack context, Collection<ServerPlayer> targets) {
        Sets.SetView ids = Sets.difference((Set)AxolootlVariant.getRegistry(context.m_5894_()).m_6566_(), AxRegistry.AxolootlVariantsReg.getInvalidEntries());
        for (ServerPlayer target : targets) {
            target.getCapability(Axolootl.AXOLOOTL_RESEARCH_CAPABILITY).ifPresent(arg_0 -> AxolootlResearchCommand.lambda$addAll$9((Set)ids, target, arg_0));
        }
        if (targets.size() == 1) {
            context.m_81354_((Component)Component.m_237110_((String)"commands.axresearch.addall.single.success", (Object[])new Object[]{ids.size(), targets.iterator().next().m_5446_()}), true);
        } else {
            context.m_81354_((Component)Component.m_237110_((String)"commands.axresearch.addall.multiple.success", (Object[])new Object[]{ids.size(), targets.size()}), true);
        }
        return 1;
    }

    private static int remove(CommandSourceStack context, Collection<ServerPlayer> targets, ResourceLocation id) throws CommandSyntaxException {
        if (!AxRegistry.AxolootlVariantsReg.isValid(id)) {
            throw INVALID_VARIANT.create((Object)id);
        }
        Registry<AxolootlVariant> registry = AxolootlVariant.getRegistry(context.m_5894_());
        Optional oVariant = registry.m_6612_(id);
        if (oVariant.isEmpty()) {
            throw UNKNOWN_VARIANT.create((Object)id);
        }
        for (ServerPlayer target : targets) {
            target.getCapability(Axolootl.AXOLOOTL_RESEARCH_CAPABILITY).ifPresent(c -> c.removeAxolootl(target, id));
        }
        if (targets.size() == 1) {
            context.m_81354_((Component)Component.m_237110_((String)"commands.axresearch.remove.single.success", (Object[])new Object[]{id, targets.iterator().next().m_5446_()}), true);
        } else {
            context.m_81354_((Component)Component.m_237110_((String)"commands.axresearch.remove.multiple.success", (Object[])new Object[]{id, targets.size()}), true);
        }
        return 1;
    }

    private static int removeAll(CommandSourceStack context, Collection<ServerPlayer> targets) {
        for (ServerPlayer target : targets) {
            target.getCapability(Axolootl.AXOLOOTL_RESEARCH_CAPABILITY).ifPresent(c -> c.clear(target));
        }
        if (targets.size() == 1) {
            context.m_81354_((Component)Component.m_237110_((String)"commands.axresearch.removeall.single.success", (Object[])new Object[]{targets.iterator().next().m_5446_()}), true);
        } else {
            context.m_81354_((Component)Component.m_237110_((String)"commands.axresearch.removeall.multiple.success", (Object[])new Object[]{targets.size()}), true);
        }
        return 1;
    }

    private static /* synthetic */ void lambda$addAll$9(Set ids, ServerPlayer target, AxolootlResearchCapability c) {
        c.addAxolootls(ids);
        c.syncToClient(target);
    }
}

