/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@Immutable
public class AndModifierCondition
extends ModifierCondition {
    public static final Codec<AndModifierCondition> CODEC = LIST_CODEC.xmap(AndModifierCondition::new, AndModifierCondition::getChildren).fieldOf("children").codec();
    private final List<ModifierCondition> children;

    public AndModifierCondition(List<ModifierCondition> children) {
        this.children = ImmutableList.copyOf(children);
    }

    public List<ModifierCondition> getChildren() {
        return this.children;
    }

    @Override
    public boolean test(AquariumModifierContext aquariumModifierContext) {
        for (ModifierCondition child : this.children) {
            if (child.test(aquariumModifierContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.AND.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        ArrayList<MutableComponent> builder = new ArrayList<MutableComponent>();
        for (ModifierCondition child : this.children) {
            for (Component c : child.createDescription(registryAccess)) {
                builder.add(Component.m_237113_((String)"  ").m_7220_(c));
                builder.add(Component.m_237115_((String)"axolootl.modifier_condition.and").m_130940_(ChatFormatting.GOLD));
            }
        }
        if (!builder.isEmpty()) {
            builder.remove(builder.size() - 1);
        }
        return ImmutableList.copyOf(builder);
    }

    public String toString() {
        return "and {" + this.children.toString() + "}";
    }
}

