/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;

@Immutable
public class BlockModifierCondition
extends ModifierCondition {
    public static final Codec<BlockModifierCondition> CODEC = BlockPredicate.f_190392_.xmap(BlockModifierCondition::new, BlockModifierCondition::getPredicate).fieldOf("predicate").codec();
    private final BlockPredicate predicate;

    public BlockModifierCondition(BlockPredicate predicate) {
        this.predicate = predicate;
    }

    public BlockPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean test(AquariumModifierContext aquariumModifierContext) {
        ServerLevel level = (ServerLevel)aquariumModifierContext.getLevel();
        return this.predicate.test((Object)level, (Object)aquariumModifierContext.getPos());
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.BLOCK.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        return BlockModifierCondition.createDescription(this.predicate);
    }

    public String toString() {
        ResourceLocation id = BuiltInRegistries.f_256906_.m_7981_((Object)this.predicate.m_183575_());
        if (null == id) {
            return "block {ERROR}";
        }
        return "block {" + id.toString() + "}";
    }

    protected static List<Component> createDescription(BlockPredicate blockPredicate) {
        ArrayList<Component> list = new ArrayList<Component>();
        ResourceLocation id = BuiltInRegistries.f_256906_.m_7981_((Object)blockPredicate.m_183575_());
        if (id != null) {
            String key = Util.m_137492_((String)"block_predicate_type", (ResourceLocation)id);
            list.add((Component)Component.m_237115_((String)key));
        }
        return list;
    }
}

