/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.energy.IEnergyStorage;

@Immutable
public class EnergyModifierCondition
extends ModifierCondition {
    public static final Codec<EnergyModifierCondition> CODEC = Codec.LONG.xmap(EnergyModifierCondition::new, EnergyModifierCondition::getEnergy).fieldOf("energy").codec();
    private static final Capability<IEnergyStorage> ENERGY_STORAGE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEnergyStorage>(){});
    private final long energy;

    public EnergyModifierCondition(long energy) {
        this.energy = Math.max(0L, energy);
    }

    public long getEnergy() {
        return this.energy;
    }

    @Override
    public boolean test(AquariumModifierContext aquariumModifierContext) {
        BlockPos pos = aquariumModifierContext.getPos();
        BlockEntity blockEntity = aquariumModifierContext.getLevel().m_7702_(pos);
        if (null == blockEntity) {
            return false;
        }
        Optional oEnergy = blockEntity.getCapability(ENERGY_STORAGE_CAPABILITY).resolve();
        if (oEnergy.isEmpty()) {
            return false;
        }
        return (long)((IEnergyStorage)oEnergy.get()).getEnergyStored() >= this.getEnergy();
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.ENERGY.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.energy", (Object[])new Object[]{this.energy}));
    }

    public String toString() {
        return "energy {" + this.getEnergy() + "}";
    }
}

