/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.util.AxCodecUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

@Immutable
public abstract class ModifierCondition
implements Predicate<AquariumModifierContext> {
    public static final Codec<ModifierCondition> DIRECT_CODEC = ExtraCodecs.m_184415_(() -> AxRegistry.MODIFIER_CONDITION_SERIALIZERS_SUPPLIER.get().getCodec()).dispatch(ModifierCondition::getCodec, Function.identity());
    public static final Codec<Holder<ModifierCondition>> HOLDER_CODEC = RegistryFileCodec.m_135589_(AxRegistry.Keys.MODIFIER_CONDITIONS, DIRECT_CODEC);
    public static final Codec<HolderSet<ModifierCondition>> HOLDER_SET_CODEC = RegistryCodecs.m_206279_(AxRegistry.Keys.MODIFIER_CONDITIONS, DIRECT_CODEC);
    public static final Codec<List<ModifierCondition>> LIST_CODEC = AxCodecUtils.listOrElementCodec(DIRECT_CODEC);
    private final List<Component> description = new ArrayList<Component>();
    private final List<Component> descriptionView = Collections.unmodifiableList(this.description);

    public abstract Codec<? extends ModifierCondition> getCodec();

    public final List<Component> getDescription(RegistryAccess registryAccess) {
        if (this.description.isEmpty()) {
            this.description.addAll(this.createDescription(registryAccess));
        }
        return this.descriptionView;
    }

    protected abstract List<Component> createDescription(RegistryAccess var1);

    protected static Component createIntDescription(MinMaxBounds.Ints intProvider) {
        String prefix = "axolootl.modifier_condition.int.";
        if (intProvider.m_55305_() != null && intProvider.m_55326_() != null && ((Integer)intProvider.m_55305_()).equals(intProvider.m_55326_())) {
            return Component.m_237110_((String)"axolootl.modifier_condition.int.exact", (Object[])new Object[]{intProvider.m_55326_()});
        }
        if (intProvider.m_55305_() != null && intProvider.m_55326_() != null && (Integer)intProvider.m_55305_() > 0 && (Integer)intProvider.m_55326_() < Integer.MAX_VALUE) {
            return Component.m_237110_((String)"axolootl.modifier_condition.int.range", (Object[])new Object[]{intProvider.m_55305_(), intProvider.m_55326_()});
        }
        if (intProvider.m_55326_() != null) {
            return Component.m_237110_((String)"axolootl.modifier_condition.int.max", (Object[])new Object[]{intProvider.m_55326_()});
        }
        if (intProvider.m_55305_() != null) {
            return Component.m_237110_((String)"axolootl.modifier_condition.int.min", (Object[])new Object[]{intProvider.m_55305_()});
        }
        return Component.m_237119_();
    }

    protected static <T> List<Component> createHolderSetDescription(Registry<T> registry, HolderSet<T> holderSet, Function<T, Component> toText) {
        ArrayList<Component> list = new ArrayList<Component>();
        Either unwrapped = holderSet.m_203440_();
        unwrapped.ifLeft(e -> list.add((Component)Component.m_237110_((String)"axolootl.modifier_condition.holder_set.tag", (Object[])new Object[]{Component.m_237113_((String)("#" + e.f_203868_())).m_130940_(ChatFormatting.GRAY)})));
        unwrapped.ifRight(holderList -> {
            for (Holder holder : holderList) {
                list.addAll(ModifierCondition.createHolderDescription(registry, holder, toText));
            }
        });
        return list;
    }

    protected static <T> List<Component> createHolderDescription(Registry<T> registry, Holder<T> holder, Function<T, Component> toText) {
        ArrayList<Component> list = new ArrayList<Component>();
        Either unwrappedHolder = holder.m_203439_();
        unwrappedHolder.ifLeft(id -> list.add((Component)toText.apply(registry.m_6246_(id))));
        unwrappedHolder.ifRight(o -> list.add((Component)toText.apply(o)));
        return list;
    }

    protected static <T> Component createResourceKeyDescription(ResourceKey<T> resourceKey) {
        return Component.m_237113_((String)resourceKey.m_135782_().toString()).m_130940_(ChatFormatting.GRAY);
    }

    protected static <T> List<Component> createCountedDescription(String key, MinMaxBounds.Ints count, Registry<T> registry, HolderSet<T> holderSet, Function<T, Component> toText) {
        List<Component> descriptionList = ModifierCondition.createHolderSetDescription(registry, holderSet, toText);
        if (descriptionList.size() == 1) {
            return ImmutableList.of((Object)Component.m_237110_((String)(key + ".single"), (Object[])new Object[]{ModifierCondition.createIntDescription(count), descriptionList.get(0)}));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Component.m_237110_((String)(key + ".multiple"), (Object[])new Object[]{ModifierCondition.createIntDescription(count)}));
        for (Component c : descriptionList) {
            builder.add((Object)Component.m_237113_((String)"  ").m_7220_(c));
        }
        return builder.build();
    }

    public static Registry<ModifierCondition> getRegistry(RegistryAccess access) {
        return access.m_175515_(AxRegistry.Keys.MODIFIER_CONDITIONS);
    }
}

