/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import axolootl.util.AxCodecUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

@Immutable
public class TimeModifierCondition
extends ModifierCondition {
    public static final Codec<TimeModifierCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("period").forGetter(TimeModifierCondition::getPeriod), (App)AxCodecUtils.NON_NEGATIVE_INTS_CODEC.fieldOf("range").forGetter(TimeModifierCondition::getRange)).apply((Applicative)instance, TimeModifierCondition::new));
    @Nullable
    private final Long period;
    private final MinMaxBounds.Ints range;

    public TimeModifierCondition(Optional<Long> period, MinMaxBounds.Ints range) {
        this.period = period.orElse(null);
        this.range = range;
    }

    public Optional<Long> getPeriod() {
        return Optional.ofNullable(this.period);
    }

    public MinMaxBounds.Ints getRange() {
        return this.range;
    }

    @Override
    public boolean test(AquariumModifierContext aquariumModifierContext) {
        ServerLevel serverlevel = (ServerLevel)aquariumModifierContext.getLevel();
        long i = serverlevel.m_46468_();
        if (this.period != null) {
            i %= this.period.longValue();
        }
        return this.getRange().m_55390_((int)i);
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.TIME.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        int min = Optional.ofNullable((Integer)this.range.m_55305_()).orElse(0);
        int max = Optional.ofNullable((Integer)this.range.m_55326_()).orElse(0);
        if (this.period != null) {
            return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.time.period", (Object[])new Object[]{min, max, this.period}));
        }
        return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.time", (Object[])new Object[]{min, max}));
    }

    public String toString() {
        return "time {range=(" + Optional.ofNullable((Integer)this.getRange().m_55305_()) + "," + Optional.ofNullable((Integer)this.getRange().m_55326_()) + ") period=" + Optional.ofNullable(this.getPeriod()) + "}";
    }
}

