/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;

@Immutable
public class WeatherModifierCondition
extends ModifierCondition {
    public static final Codec<WeatherModifierCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("raining").forGetter(WeatherModifierCondition::isRaining), (App)Codec.BOOL.optionalFieldOf("thundering").forGetter(WeatherModifierCondition::isThundering)).apply((Applicative)instance, WeatherModifierCondition::new));
    @Nullable
    private final Boolean isRaining;
    @Nullable
    private final Boolean isThundering;

    public WeatherModifierCondition(Optional<Boolean> raining, Optional<Boolean> thundering) {
        this.isRaining = raining.orElse(null);
        this.isThundering = thundering.orElse(null);
    }

    @Nullable
    public Optional<Boolean> isRaining() {
        return Optional.ofNullable(this.isRaining);
    }

    @Nullable
    public Optional<Boolean> isThundering() {
        return Optional.ofNullable(this.isThundering);
    }

    @Override
    public boolean test(AquariumModifierContext aquariumModifierContext) {
        ServerLevel serverlevel = (ServerLevel)aquariumModifierContext.getLevel();
        if (this.isRaining != null && this.isRaining.booleanValue() != serverlevel.m_46471_()) {
            return false;
        }
        return this.isThundering == null || this.isThundering.booleanValue() == serverlevel.m_46470_();
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.WEATHER.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        MutableComponent cRaining = Component.m_237115_((String)"axolootl.modifier_condition.weather.raining");
        MutableComponent cThundering = Component.m_237115_((String)"axolootl.modifier_condition.weather.thundering");
        MutableComponent cRainingText = null;
        MutableComponent cThunderingText = null;
        if (this.isRaining != null) {
            MutableComponent mutableComponent = cRainingText = this.isRaining != false ? cRaining : Component.m_237110_((String)"axolootl.modifier_condition.weather.not", (Object[])new Object[]{cRaining});
        }
        if (this.isThundering != null) {
            MutableComponent mutableComponent = cThunderingText = this.isThundering != false ? cThundering : Component.m_237110_((String)"axolootl.modifier_condition.weather.not", (Object[])new Object[]{cThundering});
        }
        if (cRainingText != null && cThunderingText != null) {
            return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.weather.multiple", (Object[])new Object[]{cRainingText, cThunderingText}));
        }
        if (cRainingText != null) {
            return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.weather.single", (Object[])new Object[]{cRainingText}));
        }
        if (cThunderingText != null) {
            return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.weather.single", (Object[])new Object[]{cThunderingText}));
        }
        return ImmutableList.of((Object)Component.m_237115_((String)"axolootl.modifier_condition.weather.never"));
    }

    public String toString() {
        return "weather {raining=" + this.isRaining() + ", thundering=" + this.isThundering() + "}";
    }
}

