/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_tab;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.data.aquarium_tab.WorldlyMenuProvider;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class AquariumTab
implements IAquariumTab {
    protected final Predicate<ControllerBlockEntity> availablePredicate;
    protected final Function<ControllerBlockEntity, WorldlyMenuProvider> menuProvider;
    protected final LazyOptional<ItemStack> icon;
    protected final LazyOptional<List<IAquariumTab>> before;
    protected final LazyOptional<List<IAquariumTab>> after;
    protected final Predicate<BlockState> accepts;
    protected String descriptionId;
    protected Component title;
    protected Component unavailableTitle;

    public AquariumTab(Predicate<ControllerBlockEntity> availablePredicate, Function<ControllerBlockEntity, WorldlyMenuProvider> menuProvider, NonNullSupplier<ItemStack> icon, NonNullSupplier<List<IAquariumTab>> before, NonNullSupplier<List<IAquariumTab>> after, Predicate<BlockState> accepts) {
        this.availablePredicate = availablePredicate;
        this.menuProvider = menuProvider;
        this.icon = LazyOptional.of(icon);
        this.before = LazyOptional.of(before);
        this.after = LazyOptional.of(after);
        this.accepts = accepts;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isAvailable(@Nullable ControllerBlockEntity blockEntity) {
        if (null == blockEntity) {
            return false;
        }
        return this.availablePredicate.test(blockEntity);
    }

    @Override
    public Component getTitle(boolean isAvailable) {
        if (null == this.title) {
            this.title = Component.m_237115_((String)this.getDescriptionId());
            this.unavailableTitle = this.title.m_6881_().m_130940_(ChatFormatting.RED);
        }
        return isAvailable ? this.title : this.unavailableTitle;
    }

    public String getDescriptionId() {
        if (null == this.descriptionId) {
            this.descriptionId = Util.m_137492_((String)"gui.controller_tab", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return AxRegistry.AQUARIUM_TABS_SUPPLIER.get().getKey((Object)this);
    }

    @Override
    public Optional<WorldlyMenuProvider> getMenuProvider(ControllerBlockEntity blockEntity, @Nullable BlockPos pos) {
        if (pos != null) {
            return Optional.ofNullable(IAquariumTab.getMenuProviderAt(blockEntity.m_58904_(), pos));
        }
        return Optional.ofNullable(this.menuProvider.apply(blockEntity));
    }

    @Override
    public ItemStack getIcon() {
        return (ItemStack)this.icon.orElse((Object)ItemStack.f_41583_);
    }

    @Override
    public List<IAquariumTab> getBeforeTabs() {
        return (List)this.before.orElse((Object)ImmutableList.of());
    }

    @Override
    public List<IAquariumTab> getAfterTabs() {
        return (List)this.after.orElse((Object)ImmutableList.of());
    }

    @Override
    public boolean isFor(LevelAccessor level, BlockPos pos, BlockState blockState) {
        return this.accepts.test(blockState);
    }

    public static class Builder {
        private Predicate<ControllerBlockEntity> availablePredicate = c -> true;
        private Function<ControllerBlockEntity, WorldlyMenuProvider> menuProvider = c -> null;
        private NonNullSupplier<ItemStack> icon = () -> ItemStack.f_41583_;
        private NonNullSupplier<List<IAquariumTab>> before = () -> List.of();
        private NonNullSupplier<List<IAquariumTab>> after = () -> List.of();
        private Predicate<BlockState> accepts = b -> false;

        private Builder() {
        }

        public Builder available(Predicate<ControllerBlockEntity> availablePredicate) {
            this.availablePredicate = availablePredicate;
            return this;
        }

        public Builder menuProvider(Function<ControllerBlockEntity, WorldlyMenuProvider> menuProvider) {
            this.menuProvider = menuProvider;
            return this;
        }

        public Builder icon(NonNullSupplier<ItemStack> icon) {
            this.icon = icon;
            return this;
        }

        public Builder accepts(TagKey<Block> tagKey) {
            return this.accepts((BlockState b) -> b.m_204336_(tagKey));
        }

        public Builder accepts(Predicate<BlockState> accepts) {
            this.accepts = accepts;
            return this;
        }

        public Builder before(NonNullSupplier<List<IAquariumTab>> before) {
            this.before = before;
            return this;
        }

        public Builder after(NonNullSupplier<List<IAquariumTab>> after) {
            this.after = after;
            return this;
        }

        public AquariumTab build() {
            return new AquariumTab(this.availablePredicate, this.menuProvider, this.icon, this.before, this.after, this.accepts);
        }
    }
}

