/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_tab;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.data.aquarium_tab.WorldlyMenuProvider;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IAquariumTab {
    public boolean isAvailable(@Nullable ControllerBlockEntity var1);

    public Component getTitle(boolean var1);

    public Optional<WorldlyMenuProvider> getMenuProvider(ControllerBlockEntity var1, @Nullable BlockPos var2);

    public boolean isFor(LevelAccessor var1, BlockPos var2, BlockState var3);

    public ItemStack getIcon();

    public List<IAquariumTab> getBeforeTabs();

    public List<IAquariumTab> getAfterTabs();

    default public int getSortedIndex() {
        return AxRegistry.AquariumTabsReg.getSortedTabs().indexOf(this);
    }

    public static Optional<IAquariumTab> forBlock(LevelAccessor level, BlockPos pos, BlockState blockState) {
        for (IAquariumTab entry : AxRegistry.AQUARIUM_TABS_SUPPLIER.get()) {
            if (!entry.isFor(level, pos, blockState)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    @Nullable
    public static WorldlyMenuProvider getFirstMenuProvider(Level level, Set<BlockPos> positions) {
        for (BlockPos p : positions) {
            WorldlyMenuProvider provider = IAquariumTab.getMenuProviderAt(level, p);
            if (provider == null) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static WorldlyMenuProvider getMenuProviderAt(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            return new WorldlyMenuProvider(pos, provider);
        }
        return null;
    }
}

