/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.axolootl_variant;

import axolootl.util.AxCodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

@Immutable
public class AxolootlModelSettings {
    public static final ResourceLocation ENTITY_MODEL = new ResourceLocation("axolootl", "axolootl");
    public static final ResourceLocation ENTITY_TEXTURE = new ResourceLocation("axolootl", "axolotl_lucy");
    public static final ResourceLocation EMPTY_ENTITY_ANIMATIONS = new ResourceLocation("axolootl", "axolootl");
    public static final AxolootlModelSettings EMPTY = new AxolootlModelSettings(ENTITY_MODEL, Optional.empty(), ENTITY_TEXTURE, Optional.empty(), Optional.empty(), -1, -1);
    public static final Codec<AxolootlModelSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("entity", (Object)ENTITY_MODEL).forGetter(o -> o.entityGeoModelKey), (App)ResourceLocation.f_135803_.optionalFieldOf("animations").forGetter(o -> Optional.ofNullable(o.entityGeoAnimationsKey)), (App)ResourceLocation.f_135803_.optionalFieldOf("texture", (Object)ENTITY_TEXTURE).forGetter(o -> o.entityTextureKey), (App)ResourceLocation.f_135803_.optionalFieldOf("primary_texture").forGetter(o -> Optional.ofNullable(o.entityPrimaryTextureKey)), (App)ResourceLocation.f_135803_.optionalFieldOf("secondary_texture").forGetter(o -> Optional.ofNullable(o.entitySecondaryTextureKey)), (App)AxCodecUtils.HEX_OR_INT_CODEC.optionalFieldOf("primary_color", (Object)-1).forGetter(AxolootlModelSettings::getPrimaryColor), (App)AxCodecUtils.HEX_OR_INT_CODEC.optionalFieldOf("secondary_color", (Object)-1).forGetter(AxolootlModelSettings::getSecondaryColor)).apply((Applicative)instance, AxolootlModelSettings::new));
    private final ResourceLocation entityGeoModelKey;
    private final ResourceLocation entityGeoModel;
    @Nullable
    private final ResourceLocation entityGeoAnimationsKey;
    @Nullable
    private final ResourceLocation entityGeoAnimations;
    private final ResourceLocation entityTextureKey;
    private final ResourceLocation entityTexture;
    @Nullable
    private final ResourceLocation entityPrimaryTextureKey;
    @Nullable
    private final ResourceLocation entityPrimaryTexture;
    @Nullable
    private final ResourceLocation entitySecondaryTextureKey;
    @Nullable
    private final ResourceLocation entitySecondaryTexture;
    private final int primaryColor;
    private final Vector3f primaryColors;
    private final int secondaryColor;
    private final Vector3f secondaryColors;

    public AxolootlModelSettings(ResourceLocation entityGeoModel, Optional<ResourceLocation> entityGeoAnimations, ResourceLocation entityTexture, Optional<ResourceLocation> entityPrimaryTexture, Optional<ResourceLocation> entitySecondaryTexture, int primaryColor, int secondaryColor) {
        this.entityGeoModelKey = entityGeoModel;
        this.entityGeoModel = new ResourceLocation(entityGeoModel.m_135827_(), "geo/entity/axolootl/" + entityGeoModel.m_135815_() + ".geo.json");
        this.entityGeoAnimationsKey = entityGeoAnimations.orElse(null);
        this.entityGeoAnimations = entityGeoAnimations.map(animations -> new ResourceLocation(animations.m_135827_(), "animations/entity/axolootl/" + animations.m_135815_() + ".animation.json")).orElse(null);
        this.entityTextureKey = entityTexture;
        this.entityTexture = new ResourceLocation(entityTexture.m_135827_(), "textures/entity/axolootl/" + entityTexture.m_135815_() + ".png");
        this.entityPrimaryTextureKey = entityPrimaryTexture.orElse(null);
        this.entityPrimaryTexture = entityPrimaryTexture.map(texture -> new ResourceLocation(texture.m_135827_(), "textures/entity/axolootl/" + texture.m_135815_() + ".png")).orElse(null);
        this.entitySecondaryTextureKey = entitySecondaryTexture.orElse(null);
        this.entitySecondaryTexture = entitySecondaryTexture.map(texture -> new ResourceLocation(texture.m_135827_(), "textures/entity/axolootl/" + texture.m_135815_() + ".png")).orElse(null);
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.primaryColors = primaryColor < 0 ? new Vector3f(1.0f, 1.0f, 1.0f) : AxolootlModelSettings.unpackColor(primaryColor);
        this.secondaryColors = primaryColor < 0 ? new Vector3f(1.0f, 1.0f, 1.0f) : AxolootlModelSettings.unpackColor(secondaryColor);
    }

    public ResourceLocation getEntityGeoModel() {
        return this.entityGeoModel;
    }

    public ResourceLocation getEntityTexture() {
        return this.entityTexture;
    }

    public ResourceLocation getEntityGeoAnimations() {
        return this.entityGeoAnimations;
    }

    public Optional<ResourceLocation> getOptionalEntityGeoAnimations() {
        return Optional.ofNullable(this.entityGeoAnimations);
    }

    public Optional<ResourceLocation> getOptionalEntityPrimaryTexture() {
        return Optional.ofNullable(this.entityPrimaryTexture);
    }

    public Optional<ResourceLocation> getOptionalEntitySecondaryTexture() {
        return Optional.ofNullable(this.entitySecondaryTexture);
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public Vector3f getPrimaryColors() {
        return this.primaryColors;
    }

    public Vector3f getSecondaryColors() {
        return this.secondaryColors;
    }

    public static Vector3f unpackColor(int color) {
        float red = color >> 16 & 0xFF;
        float green = color >> 8 & 0xFF;
        float blue = color & 0xFF;
        return new Vector3f(red / 255.0f, green / 255.0f, blue / 255.0f);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ModelSettings{");
        builder.append(" colors=(" + this.getPrimaryColor() + ", " + this.getSecondaryColor() + ")");
        builder.append(" entity=" + this.getEntityGeoModel().toString());
        builder.append(" texture=" + this.getEntityTexture().toString() + ", " + this.getOptionalEntityPrimaryTexture().toString() + ", " + this.getOptionalEntitySecondaryTexture().toString());
        builder.append(" }");
        return builder.toString();
    }
}

