/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.axolootl_variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Bonuses {
    private static final long FALLBACK_DURATION = 2000L;
    public static final Bonuses EMPTY = new Bonuses(0.0, 0.0, 0.0, 0L);
    public static final Codec<Bonuses> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("generation", (Object)0.0).forGetter(Bonuses::getGenerationBonus), (App)Codec.DOUBLE.optionalFieldOf("breed", (Object)0.0).forGetter(Bonuses::getBreedBonus), (App)Codec.DOUBLE.optionalFieldOf("feed", (Object)0.0).forGetter(Bonuses::getFeedBonus), (App)Codec.LONG.optionalFieldOf("duration", (Object)2000L).forGetter(Bonuses::getDuration)).apply((Applicative)instance, Bonuses::new));
    public static final Codec<Bonuses> CODEC = Codec.either((Codec)Codec.DOUBLE, DIRECT_CODEC).xmap(either -> (Bonuses)either.map(Bonuses::new, Function.identity()), obj -> obj.isSimple() ? Either.left((Object)obj.getGenerationBonus()) : Either.right((Object)obj));
    private final double generationBonus;
    private final double breedBonus;
    private final double feedBonus;
    private final long duration;

    public Bonuses(double generationBonus) {
        this(generationBonus, 0.0, 0.0, 2000L);
    }

    public Bonuses(double generationBonus, double breedBonus, double feedBonus, long duration) {
        this.generationBonus = generationBonus;
        this.breedBonus = breedBonus;
        this.feedBonus = feedBonus;
        this.duration = duration;
    }

    public double getGenerationBonus() {
        return this.generationBonus;
    }

    public double getBreedBonus() {
        return this.breedBonus;
    }

    public double getFeedBonus() {
        return this.feedBonus;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isSimple() {
        return !(this.breedBonus > 0.0) && !(this.feedBonus > 0.0) && this.duration == 2000L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bonuses)) {
            return false;
        }
        Bonuses bonuses = (Bonuses)o;
        return Double.compare(bonuses.generationBonus, this.generationBonus) == 0 && Double.compare(bonuses.breedBonus, this.breedBonus) == 0 && Double.compare(bonuses.feedBonus, this.feedBonus) == 0 && bonuses.duration == this.duration;
    }

    public int hashCode() {
        return Objects.hash(this.generationBonus, this.breedBonus, this.feedBonus, this.duration);
    }
}

