/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.breeding;

import axolootl.AxRegistry;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.data.breeding.AxolootlBreeding;
import axolootl.data.breeding_modifier.AxolootlBreedingModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.Level;

public class AxolootlBreedingWrapper {
    private final AxolootlBreeding breeding;
    private final SimpleWeightedRandomList<ResourceKey<AxolootlVariant>> result;

    public AxolootlBreedingWrapper(RegistryAccess access, AxolootlBreeding breeding, List<AxolootlBreedingModifier> modifiers) {
        this.breeding = breeding;
        ArrayList<WeightedEntry.Wrapper<ResourceKey<AxolootlVariant>>> builder = new ArrayList<WeightedEntry.Wrapper<ResourceKey<AxolootlVariant>>>(breeding.getResult().m_146338_());
        for (AxolootlBreedingModifier modifier : modifiers) {
            modifier.apply(builder, AxolootlBreedingModifier.Phase.PRE);
        }
        for (AxolootlBreedingModifier modifier : modifiers) {
            modifier.apply(builder, AxolootlBreedingModifier.Phase.ADD);
        }
        for (AxolootlBreedingModifier modifier : modifiers) {
            modifier.apply(builder, AxolootlBreedingModifier.Phase.REMOVE);
        }
        for (AxolootlBreedingModifier modifier : modifiers) {
            modifier.apply(builder, AxolootlBreedingModifier.Phase.POST);
        }
        builder.removeIf(wrapper -> !AxRegistry.AxolootlVariantsReg.isValid(((ResourceKey)wrapper.m_146310_()).m_135782_()));
        this.result = new SimpleWeightedRandomList(builder);
    }

    public static Optional<AxolootlBreedingWrapper> getBreedingRecipe(Level level, AxolootlVariant first, AxolootlVariant second) {
        if (AxolootlVariant.EMPTY.equals(first) || AxolootlVariant.EMPTY.equals(second)) {
            return Optional.empty();
        }
        Optional<AxolootlBreeding> match = AxolootlBreeding.getRegistry(level.m_8891_()).m_6579_().stream().filter(e -> ((AxolootlBreeding)e.getValue()).matches(level, first, second)).findFirst().map(Map.Entry::getValue);
        if (match.isEmpty()) {
            return Optional.empty();
        }
        AxolootlBreedingWrapper wrapper = AxRegistry.AxolootlBreedingReg.getWrapper(level.m_8891_(), match.get());
        if (wrapper.getResult().m_146338_().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(wrapper);
    }

    public AxolootlVariant getBreedResult(Level level, AxolootlVariant aFirst, AxolootlVariant aSecond, RandomSource random) {
        return (AxolootlVariant)AxolootlVariant.getRegistry(level.m_8891_()).m_7745_(this.sampleResult(random).orElse(this.breeding.getFirst()).m_135782_());
    }

    public Optional<ResourceKey<AxolootlVariant>> sampleResult(RandomSource random) {
        Optional oVariant = this.getResult().m_216829_(random);
        if (oVariant.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((ResourceKey)((WeightedEntry.Wrapper)oVariant.get()).m_146310_());
    }

    public AxolootlBreeding getBreeding() {
        return this.breeding;
    }

    public SimpleWeightedRandomList<ResourceKey<AxolootlVariant>> getResult() {
        return this.result;
    }
}

