/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.breeding_modifier;

import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.util.AxCodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;

@Immutable
public class WeightedEntryPredicate
implements Predicate<WeightedEntry.Wrapper<ResourceKey<AxolootlVariant>>> {
    public static final Codec<WeightedEntryPredicate> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("variant").forGetter(o -> Optional.ofNullable(o.variantId)), (App)AxCodecUtils.POSITIVE_INTS_CODEC.optionalFieldOf("weight").forGetter(o -> Optional.ofNullable(o.weight))).apply((Applicative)instance, WeightedEntryPredicate::new));
    public static final Codec<WeightedEntryPredicate> CODEC = Codec.either((Codec)Codec.STRING, DIRECT_CODEC).xmap(either -> (WeightedEntryPredicate)either.map(s -> new WeightedEntryPredicate(Optional.of(s), Optional.empty()), Function.identity()), o -> o.weight == null && o.variantId != null ? Either.left((Object)o.variantId) : Either.right((Object)o));
    @Nullable
    private final String variantId;
    @Nullable
    private final String namespace;
    @Nullable
    private final String path;
    @Nullable
    private final MinMaxBounds.Ints weight;

    private WeightedEntryPredicate(Optional<String> variantId, Optional<MinMaxBounds.Ints> weight) {
        this.variantId = variantId.orElse(null);
        this.weight = weight.orElse(null);
        if (variantId.isPresent()) {
            String s = variantId.get();
            int index = s.indexOf(":");
            if (index > 0 && index < s.length() - 1) {
                String sModId = s.substring(0, index);
                String sVariantId = s.substring(index + 1);
                this.namespace = sModId.equals("*") ? null : sModId;
                this.path = sVariantId.equals("*") ? null : sVariantId;
            } else {
                this.namespace = null;
                this.path = null;
            }
        } else {
            this.namespace = null;
            this.path = null;
        }
    }

    @Override
    public boolean test(WeightedEntry.Wrapper<ResourceKey<AxolootlVariant>> entry) {
        ResourceLocation id = ((ResourceKey)entry.m_146310_()).m_135782_();
        boolean matches = null == this.namespace || id.m_135827_().equals(this.namespace);
        matches &= null == this.path || id.m_135815_().equals(this.path);
        return matches &= null == this.weight || this.weight.m_55390_(entry.m_142631_().m_146281_());
    }
}

