/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.AxRegistry;
import axolootl.data.resource_generator.ResourceDescriptionGroup;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.data.resource_generator.ResourceType;
import axolootl.data.resource_generator.ResourceTypes;
import axolootl.util.AxCodecUtils;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

@Immutable
public class AndResourceGenerator
extends ResourceGenerator {
    public static final Codec<AndResourceGenerator> CODEC = AxCodecUtils.listOrElementCodec(ResourceGenerator.HOLDER_CODEC).xmap(AndResourceGenerator::new, AndResourceGenerator::getChildren).fieldOf("values").codec();
    private final List<Holder<ResourceGenerator>> children;
    private final Supplier<Set<ResourceType>> resourceTypes;

    public AndResourceGenerator(List<Holder<ResourceGenerator>> list) {
        this.children = list;
        this.resourceTypes = Suppliers.memoize(() -> {
            ImmutableSet.Builder typeBuilder = ImmutableSet.builder();
            typeBuilder.add((Object)ResourceTypes.MULTIPLE);
            this.getChildren().forEach(entry -> typeBuilder.addAll(((ResourceGenerator)entry.m_203334_()).getResourceTypes()));
            return typeBuilder.build();
        });
    }

    public List<Holder<ResourceGenerator>> getChildren() {
        return this.children;
    }

    @Override
    public Set<ResourceType> getResourceTypes() {
        return this.resourceTypes.get();
    }

    @Override
    public Collection<ItemStack> getRandomEntries(LivingEntity entity, RandomSource random) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.getChildren().forEach(entry -> builder.addAll(((ResourceGenerator)entry.m_203334_()).getRandomEntries(entity, random)));
        return builder.build();
    }

    @Override
    public Codec<? extends ResourceGenerator> getCodec() {
        return (Codec)AxRegistry.ResourceGeneratorsReg.AND.get();
    }

    @Override
    protected List<ResourceDescriptionGroup> createDescription() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Holder<ResourceGenerator> entry : this.getChildren()) {
            for (ResourceDescriptionGroup description : ((ResourceGenerator)entry.m_203334_()).getDescription()) {
                builder.add((Object)ResourceDescriptionGroup.builder(description, 1, 1).forceShowWeight().build());
            }
        }
        return builder.build();
    }

    public String toString() {
        return "And: {" + this.children.toString() + "}";
    }
}

