/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.data.resource_generator.ResourceDescriptionGroup;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.data.resource_generator.ResourceTypes;
import axolootl.data.resource_generator.SimpleResourceGenerator;
import axolootl.util.AxCodecUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@Immutable
public class BlockDropsResourceGenerator
extends SimpleResourceGenerator {
    public static final Codec<BlockDropsResourceGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AxCodecUtils.ITEM_OR_STACK_CODEC.optionalFieldOf("tool", (Object)ItemStack.f_41583_).forGetter(BlockDropsResourceGenerator::getTool), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(BlockDropsResourceGenerator::getBlockProvider)).apply((Applicative)instance, BlockDropsResourceGenerator::new));
    private final ItemStack tool;
    private final BlockStateProvider blockProvider;

    public BlockDropsResourceGenerator(ItemStack tool, BlockStateProvider blockProvider) {
        super(ResourceTypes.BLOCK);
        this.tool = tool;
        this.blockProvider = blockProvider;
    }

    public ItemStack getTool() {
        return this.tool;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    private static Component getBlockName(BlockState blockState) {
        return Component.m_237115_((String)blockState.m_60734_().m_7705_());
    }

    @Override
    public Collection<ItemStack> getRandomEntries(LivingEntity entity, RandomSource random) {
        MinecraftServer server = entity.m_20194_();
        if (null == server) {
            return ImmutableList.of();
        }
        BlockState blockState = this.getBlockProvider().m_213972_(random, entity.m_20183_());
        ResourceLocation lootTableId = blockState.m_60734_().m_60589_();
        LootTable lootTable = server.m_129898_().m_79217_(lootTableId);
        if (lootTable == LootTable.f_79105_) {
            Axolootl.LOGGER.warn("[ResourceGenerator#getRandomEntries] Failed to load loot table " + lootTableId);
            return ImmutableList.of();
        }
        LootContext context = this.createContext(entity, blockState, random);
        return lootTable.m_230922_(context);
    }

    @Override
    public Codec<? extends ResourceGenerator> getCodec() {
        return (Codec)AxRegistry.ResourceGeneratorsReg.BLOCK.get();
    }

    protected LootContext createContext(LivingEntity entity, BlockState block, RandomSource random) {
        return new LootContext.Builder((ServerLevel)entity.f_19853_).m_230911_(random).m_78972_(LootContextParams.f_81463_, (Object)this.tool).m_78972_(LootContextParams.f_81461_, (Object)block).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78975_(LootContextParamSets.f_81421_);
    }

    @Override
    protected List<ResourceDescriptionGroup> createDescription() {
        MutableComponent itemName;
        BlockStateProvider blockStateProvider = this.blockProvider;
        if (blockStateProvider instanceof SimpleStateProvider) {
            SimpleStateProvider p = (SimpleStateProvider)blockStateProvider;
            itemName = BlockDropsResourceGenerator.getItemDisplayName(new ItemStack((ItemLike)p.m_213972_(RandomSource.m_216327_(), BlockPos.f_121853_).m_60734_().m_5456_()));
        } else {
            itemName = Component.m_237115_((String)"axolootl.resource_generator.block.block");
        }
        String descriptionKey = "axolootl.resource_generator.block";
        MutableComponent description = this.tool.m_41619_() ? Component.m_237110_((String)"axolootl.resource_generator.block", (Object[])new Object[]{itemName}) : Component.m_237110_((String)"axolootl.resource_generator.block_with_tool", (Object[])new Object[]{itemName, BlockDropsResourceGenerator.getItemDisplayName(this.tool)});
        return ImmutableList.of((Object)ResourceDescriptionGroup.builder().withDescriptions(new Component[]{description}).ofBlockProvider(this.blockProvider));
    }

    public String toString() {
        return "BlockState: {tool=" + this.tool.m_41611_() + ", block=" + this.blockProvider.toString() + "}";
    }
}

