/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.AxRegistry;
import axolootl.data.resource_generator.ResourceDescriptionGroup;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.data.resource_generator.ResourceTypes;
import axolootl.data.resource_generator.SimpleResourceGenerator;
import axolootl.util.AxCodecUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

@Immutable
public class ItemResourceGenerator
extends SimpleResourceGenerator {
    private static final Codec<SimpleWeightedRandomList<ItemStack>> WEIGHTED_LIST_CODEC = Codec.either(AxCodecUtils.ITEM_OR_STACK_CODEC, (Codec)SimpleWeightedRandomList.m_185860_(AxCodecUtils.ITEM_OR_STACK_CODEC)).xmap(either -> (SimpleWeightedRandomList)either.map(SimpleWeightedRandomList::m_185862_, Function.identity()), list -> list.m_146338_().size() == 1 ? Either.left((Object)((ItemStack)((WeightedEntry.Wrapper)list.m_146338_().get(0)).m_146310_())) : Either.right((Object)list));
    public static final Codec<ItemResourceGenerator> CODEC = WEIGHTED_LIST_CODEC.xmap(ItemResourceGenerator::new, ItemResourceGenerator::getList).fieldOf("item").codec();
    private final SimpleWeightedRandomList<ItemStack> list;

    public ItemResourceGenerator(SimpleWeightedRandomList<ItemStack> list) {
        super(ResourceTypes.ITEM);
        this.list = list;
    }

    public SimpleWeightedRandomList<ItemStack> getList() {
        return this.list;
    }

    @Override
    public Collection<ItemStack> getRandomEntries(LivingEntity entity, RandomSource random) {
        Optional sample = this.list.m_216820_(random);
        if (sample.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)((ItemStack)sample.get()).m_41777_());
    }

    @Override
    public Codec<? extends ResourceGenerator> getCodec() {
        return (Codec)AxRegistry.ResourceGeneratorsReg.ITEM.get();
    }

    @Override
    public List<ResourceDescriptionGroup> createDescription() {
        return ImmutableList.of((Object)ResourceDescriptionGroup.builder().ofWeightedList((WeightedRandomList<WeightedEntry.Wrapper<ItemStack>>)this.list));
    }

    public String toString() {
        return "Item: " + this.list.toString();
    }
}

