/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.AxRegistry;
import axolootl.data.resource_generator.LootContextResourceGenerator;
import axolootl.data.resource_generator.ResourceDescription;
import axolootl.data.resource_generator.ResourceDescriptionGroup;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.data.resource_generator.ResourceTypes;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.registries.ForgeRegistries;

@Immutable
public class MobDropsResourceGenerator
extends LootContextResourceGenerator {
    public static final Codec<MobDropsResourceGenerator> CODEC = WEIGHTED_LIST_CODEC.xmap(MobDropsResourceGenerator::new, LootContextResourceGenerator::getList).fieldOf("loot_table").codec();

    public MobDropsResourceGenerator(SimpleWeightedRandomList<LootContextResourceGenerator.Wrapper> list) {
        super(ResourceTypes.MOB, list);
    }

    @Override
    public Codec<? extends ResourceGenerator> getCodec() {
        return (Codec)AxRegistry.ResourceGeneratorsReg.MOB.get();
    }

    @Override
    protected LootContext createContext(LivingEntity entity, RandomSource random) {
        return new LootContext.Builder((ServerLevel)entity.f_19853_).m_230911_(random).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.m_19370_((LivingEntity)entity)).m_78972_(LootContextParams.f_81458_, (Object)entity).m_78972_(LootContextParams.f_81459_, (Object)entity).m_78975_(LootContextParamSets.f_81415_);
    }

    @Override
    public List<ResourceDescriptionGroup> createDescription() {
        ResourceDescriptionGroup.Builder builder = ResourceDescriptionGroup.builder();
        int totalWeight = MobDropsResourceGenerator.calculateTotalWeight(this.getList());
        for (WeightedEntry.Wrapper wrapper : this.getList().m_146338_()) {
            ItemStack itemStack = ((LootContextResourceGenerator.Wrapper)wrapper.m_146310_()).getDisplay();
            MutableComponent description = Component.m_237110_((String)"axolootl.resource_generator.mob", (Object[])new Object[]{this.getDescriptionForLootTable(((LootContextResourceGenerator.Wrapper)wrapper.m_146310_()).getId())});
            builder.with(new ResourceDescription(itemStack, wrapper.m_142631_().m_146281_(), totalWeight, (List<Component>)ImmutableList.of((Object)description)));
        }
        return ImmutableList.of((Object)builder.build());
    }

    private Component getDescriptionForLootTable(ResourceLocation lootTableId) {
        String path = lootTableId.m_135815_();
        path = path.substring(Math.max(0, path.lastIndexOf("/") + 1));
        ResourceLocation entityId = new ResourceLocation(lootTableId.m_135827_(), path);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
        if (null == entityType) {
            return Component.m_237113_((String)("#" + lootTableId.toString())).m_130940_(ChatFormatting.GRAY);
        }
        return entityType.m_20676_();
    }

    @Override
    public String toString() {
        return "Mob: " + this.getList().toString();
    }
}

