/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

@Immutable
public class ResourceDescription {
    private final ItemStack icon;
    private final int weight;
    private final int totalWeight;
    private final double percentChance;
    private final List<Component> descriptions;
    private final Component chanceDescription;

    public ResourceDescription(ItemStack item) {
        this(item, 1, 1);
    }

    public ResourceDescription(ItemStack item, List<Component> descriptions) {
        this(item, 1, 1, descriptions);
    }

    public ResourceDescription(ItemStack item, int weight, int totalWeight) {
        this(item, weight, totalWeight, (List<Component>)ImmutableList.of());
    }

    public ResourceDescription(ItemStack item, int weight, int totalWeight, List<Component> descriptions) {
        this.icon = item;
        this.weight = weight;
        this.totalWeight = totalWeight;
        this.percentChance = (double)weight / Math.max(1.0, (double)totalWeight);
        this.chanceDescription = ResourceDescription.createChanceDescription(this.percentChance, false);
        this.descriptions = ImmutableList.copyOf(descriptions);
    }

    public boolean showChance() {
        return this.weight < this.totalWeight;
    }

    public ItemStack getItem() {
        return this.icon;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public double getPercentChance() {
        return this.percentChance;
    }

    public Component getChanceDescription() {
        return this.chanceDescription;
    }

    public List<Component> getDescriptions() {
        return this.descriptions;
    }

    public static Component createChanceDescription(double percentChance, boolean wrapped) {
        String sPercentChance = String.format("%.1f", percentChance * 100.0).replaceAll("\\.0+$", "");
        return Component.m_237110_((String)("axolootl.resource_description.chance" + (wrapped ? ".wrapped" : "")), (Object[])new Object[]{sPercentChance});
    }
}

