/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.data.resource_generator.ResourceDescription;
import axolootl.data.resource_generator.ResourceGenerator;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

@Immutable
public class ResourceDescriptionGroup {
    private final List<ResourceDescription> descriptions;
    private final int weight;
    private final int totalWeight;
    private final boolean forceShowWeight;
    private final double percentChance;
    private final Component chanceDescription;

    public ResourceDescriptionGroup(List<ResourceDescription> descriptions, int weight, int totalWeight, boolean forceShowWeight) {
        this.descriptions = ImmutableList.sortedCopyOf(Comparator.comparingDouble(ResourceDescription::getPercentChance).reversed(), descriptions);
        this.weight = weight;
        this.totalWeight = totalWeight;
        this.forceShowWeight = forceShowWeight;
        this.percentChance = (double)weight / Math.max(1.0, (double)totalWeight);
        this.chanceDescription = ResourceDescription.createChanceDescription(this.percentChance, true);
    }

    public static Builder builder(int weight, int totalWeight) {
        return new Builder(weight, totalWeight);
    }

    public static Builder builder() {
        return new Builder(1, 1);
    }

    public static Builder builder(ResourceDescriptionGroup group, int weight, int totalWeight) {
        return new Builder(group, weight, totalWeight);
    }

    public boolean showChance() {
        return this.forceShowWeight || this.weight < this.totalWeight;
    }

    public int getCount() {
        return this.descriptions.size();
    }

    public List<ResourceDescription> getDescriptions() {
        return this.descriptions;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public double getPercentChance() {
        return this.percentChance;
    }

    public Component getChanceDescription() {
        return this.chanceDescription;
    }

    public static class Builder {
        private final List<ResourceDescription> builder;
        private final List<Component> descriptions;
        private final int groupWeight;
        private final int groupTotalWeight;
        private boolean forceShowWeight;

        public Builder(int groupWeight, int groupTotalWeight) {
            this.builder = new LinkedList<ResourceDescription>();
            this.descriptions = new ArrayList<Component>();
            this.groupWeight = Math.max(1, groupWeight);
            this.groupTotalWeight = Math.max(1, groupTotalWeight);
            this.forceShowWeight = false;
        }

        public Builder(ResourceDescriptionGroup group, int groupWeight, int groupTotalWeight) {
            this.builder = new ArrayList<ResourceDescription>(group.descriptions);
            this.descriptions = new ArrayList<Component>();
            this.groupWeight = groupWeight;
            this.groupTotalWeight = groupTotalWeight;
            this.forceShowWeight = group.forceShowWeight;
        }

        public Builder withDescriptions(Component ... descriptions) {
            return this.withDescriptions((List<Component>)ImmutableList.copyOf((Object[])descriptions));
        }

        public Builder withDescriptions(List<Component> descriptions) {
            this.descriptions.clear();
            this.descriptions.addAll(descriptions);
            return this;
        }

        public Builder clearDescriptions() {
            this.descriptions.clear();
            return this;
        }

        public int size() {
            return this.builder.size();
        }

        public Builder with(ResourceDescription description) {
            this.builder.add(description);
            return this;
        }

        public Builder with(List<ResourceDescription> descriptions) {
            this.builder.addAll(descriptions);
            return this;
        }

        public Builder forceShowWeight() {
            this.forceShowWeight = true;
            return this;
        }

        public ResourceDescriptionGroup ofItem(ItemStack itemStack) {
            this.builder.add(new ResourceDescription(itemStack, this.groupWeight, this.groupTotalWeight, this.descriptions));
            return this.build();
        }

        public ResourceDescriptionGroup ofTag(TagKey<Item> tagKey) {
            MutableComponent tagName = Component.m_237113_((String)("#" + tagKey.f_203868_().toString())).m_130940_(ChatFormatting.GRAY);
            MutableComponent tagDescription = Component.m_237110_((String)"axolootl.resource_description.tag", (Object[])new Object[]{tagName});
            this.descriptions.add((Component)tagDescription);
            ITag tag = ForgeRegistries.ITEMS.tags().getTag(tagKey);
            int size = tag.size();
            if (size == 1) {
                this.builder.add(new ResourceDescription(new ItemStack((ItemLike)tag.iterator().next()), 1, 1, this.descriptions));
                return this.build();
            }
            for (Item item : tag) {
                this.builder.add(new ResourceDescription(new ItemStack((ItemLike)item), 1, size, this.descriptions));
            }
            return this.build();
        }

        public ResourceDescriptionGroup ofList(Collection<ItemStack> items) {
            int size = items.size();
            for (ItemStack item : items) {
                this.builder.add(new ResourceDescription(item, 1, size, this.descriptions));
            }
            return this.build();
        }

        public ResourceDescriptionGroup ofWeightedList(WeightedRandomList<WeightedEntry.Wrapper<ItemStack>> list) {
            return this.ofWeightedList(list, Function.identity());
        }

        public <T> ResourceDescriptionGroup ofWeightedList(WeightedRandomList<WeightedEntry.Wrapper<T>> list, Function<T, ItemStack> toItemStack) {
            int totalWeight = ResourceGenerator.calculateTotalWeight(list);
            for (WeightedEntry.Wrapper<T> entry : ResourceGenerator.createSortedWeightedList(list)) {
                ItemStack itemStack = toItemStack.apply(entry.m_146310_());
                this.builder.add(new ResourceDescription(itemStack, entry.m_142631_().m_146281_(), totalWeight, this.descriptions));
            }
            return this.build();
        }

        public ResourceDescriptionGroup ofBlockProvider(BlockStateProvider blockStateProvider) {
            if (blockStateProvider instanceof WeightedStateProvider) {
                WeightedStateProvider p = (WeightedStateProvider)blockStateProvider;
                return this.ofWeightedList((WeightedRandomList)p.f_68809_, (Function)b -> new ItemStack((ItemLike)b.m_60734_().m_5456_()));
            }
            if (blockStateProvider instanceof SimpleStateProvider) {
                SimpleStateProvider p = (SimpleStateProvider)blockStateProvider;
                return this.ofItem(new ItemStack((ItemLike)p.m_213972_(RandomSource.m_216327_(), BlockPos.f_121853_).m_60734_().m_5456_()));
            }
            throw new IllegalArgumentException("#ofBlockProvider only supports SimpleStateProvider and WeightedStateProvider, provided " + blockStateProvider.getClass());
        }

        public ResourceDescriptionGroup build() {
            return new ResourceDescriptionGroup(this.builder, this.groupWeight, this.groupTotalWeight, this.forceShowWeight);
        }
    }
}

