/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.data.resource_generator.ResourceType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;

public enum ResourceTypes implements ResourceType
{
    ITEM("item"),
    MOB("mob"),
    BLOCK("block"),
    EMPTY("empty"),
    MULTIPLE("multiple"),
    REFERENCE("reference");

    private static final Map<String, ResourceType> RESOURCE_TYPES;
    private static final Map<String, ResourceType> RESOURCE_TYPES_VIEW;
    public static final Codec<ResourceType> CODEC;
    private final String name;

    public static void bootstrap() {
        for (ResourceTypes type : ResourceTypes.values()) {
            ResourceTypes.register(type);
        }
    }

    public static ResourceType register(ResourceType resourceType) {
        if (RESOURCE_TYPES.containsKey(resourceType.m_7912_())) {
            throw new IllegalArgumentException("ResourceType failed to register with duplicate key \"" + resourceType.m_7912_() + "\"");
        }
        RESOURCE_TYPES.put(resourceType.m_7912_(), resourceType);
        return resourceType;
    }

    public static Map<String, ResourceType> getResourceTypesView() {
        return RESOURCE_TYPES_VIEW;
    }

    private ResourceTypes(String name) {
        this.name = name;
    }

    @Nullable
    public static ResourceType getByName(String name) {
        return RESOURCE_TYPES.get(name);
    }

    public String m_7912_() {
        return this.name;
    }

    private static DataResult<String> parse(String value) {
        if (!RESOURCE_TYPES.containsKey(value)) {
            return DataResult.error((String)("Unknown resource type \"" + value + "\""));
        }
        return DataResult.success((Object)value);
    }

    static {
        RESOURCE_TYPES = new HashMap<String, ResourceType>();
        RESOURCE_TYPES_VIEW = Collections.unmodifiableMap(RESOURCE_TYPES);
        CODEC = Codec.STRING.flatXmap(ResourceTypes::parse, ResourceTypes::parse).xmap(ResourceTypes::getByName, StringRepresentable::m_7912_);
    }
}

