/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.AxRegistry;
import axolootl.data.resource_generator.ResourceDescription;
import axolootl.data.resource_generator.ResourceDescriptionGroup;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.data.resource_generator.ResourceType;
import axolootl.data.resource_generator.ResourceTypes;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

@Immutable
public class SelectResourceGenerator
extends ResourceGenerator {
    public static final Codec<SelectResourceGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SimpleWeightedRandomList.m_146264_(ResourceGenerator.HOLDER_CODEC).fieldOf("pool").forGetter(SelectResourceGenerator::getChildren), (App)IntProvider.f_146532_.optionalFieldOf("rolls", (Object)ConstantInt.m_146483_((int)1)).forGetter(SelectResourceGenerator::getRolls)).apply((Applicative)instance, SelectResourceGenerator::new));
    private final SimpleWeightedRandomList<Holder<ResourceGenerator>> children;
    private final IntProvider rolls;
    private final Supplier<Set<ResourceType>> resourceTypes;

    public SelectResourceGenerator(SimpleWeightedRandomList<Holder<ResourceGenerator>> list, IntProvider rolls) {
        this.children = list;
        this.rolls = rolls;
        this.resourceTypes = Suppliers.memoize(() -> {
            ImmutableSet.Builder typeBuilder = ImmutableSet.builder();
            typeBuilder.add((Object)ResourceTypes.MULTIPLE);
            this.getChildren().m_146338_().forEach(entry -> typeBuilder.addAll(((ResourceGenerator)((Holder)entry.m_146310_()).m_203334_()).getResourceTypes()));
            return typeBuilder.build();
        });
    }

    public SimpleWeightedRandomList<Holder<ResourceGenerator>> getChildren() {
        return this.children;
    }

    public IntProvider getRolls() {
        return this.rolls;
    }

    @Override
    public Set<ResourceType> getResourceTypes() {
        return this.resourceTypes.get();
    }

    @Override
    public Collection<ItemStack> getRandomEntries(LivingEntity entity, RandomSource random) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int n = this.getRolls().m_214085_(random);
        for (int i = 0; i < n; ++i) {
            Optional oGenerator = this.children.m_216829_(random);
            if (oGenerator.isEmpty()) continue;
            builder.addAll(((ResourceGenerator)((Holder)((WeightedEntry.Wrapper)oGenerator.get()).m_146310_()).m_203334_()).getRandomEntries(entity, random));
        }
        return builder.build();
    }

    @Override
    public Codec<? extends ResourceGenerator> getCodec() {
        return (Codec)AxRegistry.ResourceGeneratorsReg.SELECT.get();
    }

    @Override
    public List<ResourceDescriptionGroup> createDescription() {
        if (this.children.m_146337_()) {
            return ImmutableList.of((Object)ResourceDescriptionGroup.builder().ofItem(ItemStack.f_41583_));
        }
        if (this.children.m_146338_().size() == 1) {
            return ((ResourceGenerator)((Holder)((WeightedEntry.Wrapper)this.children.m_146338_().get(0)).m_146310_()).m_203334_()).getDescription();
        }
        int totalWeight = 0;
        for (WeightedEntry.Wrapper child : this.children.m_146338_()) {
            int childWeight = child.m_142631_().m_146281_();
            for (ResourceDescriptionGroup group : ((ResourceGenerator)((Holder)child.m_146310_()).m_203334_()).getDescription()) {
                int groupWeight = group.getWeight();
                for (ResourceDescription description : group.getDescriptions()) {
                    totalWeight += childWeight * groupWeight * description.getWeight();
                }
            }
        }
        ResourceDescriptionGroup.Builder merger = ResourceDescriptionGroup.builder();
        for (WeightedEntry.Wrapper<ResourceGenerator> child : SelectResourceGenerator.createSortedWeightedList(this.children)) {
            int childWeight = child.m_142631_().m_146281_();
            for (ResourceDescriptionGroup group : ((ResourceGenerator)((Holder)child.m_146310_()).m_203334_()).getDescription()) {
                int groupWeight = group.getWeight();
                for (ResourceDescription description : group.getDescriptions()) {
                    merger.with(new ResourceDescription(description.getItem(), description.getWeight() * childWeight * groupWeight, totalWeight, description.getDescriptions()));
                }
            }
        }
        return ImmutableList.of((Object)merger.build());
    }

    public String toString() {
        return "Select: {" + this.children.toString() + "}";
    }
}

