/*
 * Decompiled with CFR 0.152.
 */
package axolootl.integration;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.data.breeding.AxolootlBreeding;
import axolootl.data.breeding.AxolootlBreedingWrapper;
import axolootl.integration.JeiBreedingCategory;
import axolootl.integration.JeiBreedingRecipe;
import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JeiAddon
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("axolootl", "jei");
    public static final RecipeType<JeiBreedingRecipe> BREEDING_TYPE = RecipeType.create((String)"axolootl", (String)"breeding", JeiBreedingRecipe.class);

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get(), (ingredient, context) -> ingredient.m_41784_().m_128461_("Axolootl"));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JeiBreedingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RegistryAccess registryAccess = JeiAddon.getRegistryAccess();
        Registry<AxolootlBreeding> registry = AxolootlBreeding.getRegistry(registryAccess);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AxolootlBreeding entry : registry) {
            AxolootlBreedingWrapper wrapper;
            if (!AxRegistry.AxolootlVariantsReg.isValid(entry.getFirst().m_135782_()) || !AxRegistry.AxolootlVariantsReg.isValid(entry.getSecond().m_135782_()) || (wrapper = AxRegistry.AxolootlBreedingReg.getWrapper(registryAccess, entry)).getResult().m_146337_()) continue;
            builder.add((Object)new JeiBreedingRecipe(wrapper));
        }
        ImmutableList list = builder.build();
        registration.addRecipes(BREEDING_TYPE, (List)builder.build());
        Axolootl.LOGGER.debug("Axolootl sent " + list.size() + " axolootl breeding recipes to JEI");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AxRegistry.BlockReg.BREEDER.get()), new RecipeType[]{BREEDING_TYPE});
    }

    public static RegistryAccess getRegistryAccess() {
        Minecraft minecraft = Minecraft.m_91087_();
        return minecraft.f_91073_.m_8891_();
    }
}

