/*
 * Decompiled with CFR 0.152.
 */
package axolootl.menu;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.block.entity.IAquariumControllerProvider;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.network.AxNetwork;
import axolootl.network.ServerBoundControllerCyclePacket;
import axolootl.network.ServerBoundControllerTabPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractControllerMenu
extends AbstractContainerMenu
implements IAquariumControllerProvider {
    protected final Inventory inventory;
    protected BlockPos controllerPos;
    protected ControllerBlockEntity controller;
    protected BlockPos blockPos;
    protected int tab;
    protected int cycle;
    public static final int PLAYER_INV_X = 30;
    public static final int PLAYER_INV_Y = 140;

    public AbstractControllerMenu(MenuType<?> menuType, int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity blockEntity, BlockPos blockPos, int tab, int cycle) {
        super(menuType, windowId);
        this.inventory = inv;
        this.controllerPos = controllerPos;
        this.controller = blockEntity;
        this.blockPos = blockPos;
        this.tab = this.validateTab(tab);
        if (!AxRegistry.AquariumTabsReg.getSortedTabs().get(tab).isAvailable(this.controller)) {
            this.tab = ((IAquariumTab)AxRegistry.AquariumTabsReg.CONTROLLER.get()).getSortedIndex();
        }
        this.cycle = cycle;
    }

    public int validateTab(int tab) {
        return Mth.m_14045_((int)tab, (int)0, (int)(AxRegistry.AquariumTabsReg.getTabCount() - 1));
    }

    public int getTab() {
        return this.tab;
    }

    public void setTab(int tab) {
        if (this.tab != (tab = this.validateTab(tab)) && this.inventory.f_35978_.f_19853_.m_5776_() && this.controller != null && AxRegistry.AquariumTabsReg.getSortedTabs().get(tab).isAvailable(this.controller)) {
            AxNetwork.CHANNEL.sendToServer((Object)new ServerBoundControllerTabPacket(tab));
        }
        this.tab = tab;
    }

    public int getCycle() {
        return this.cycle;
    }

    public void cycle(int amount) {
        if (amount == 0 || this.getCycleCount() <= 1) {
            return;
        }
        this.cycle = (this.cycle + this.getCycleCount() + amount) % this.getCycleCount();
        if (this.inventory.f_35978_.f_19853_.m_5776_() && this.controller != null) {
            AxNetwork.CHANNEL.sendToServer((Object)new ServerBoundControllerCyclePacket(this.cycle));
        }
    }

    public int getCycleCount() {
        return 1;
    }

    public List<BlockPos> getSortedCycleList() {
        return List.of(this.blockPos);
    }

    public boolean hasPlayerSlots() {
        return false;
    }

    protected void addPlayerSlots(Inventory inv, int startX, int startY) {
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.m_38897_(new Slot((Container)inv, inventoryX + inventoryY * 9 + 9, startX + inventoryX * 18, startY + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)inv, hotbarSlot, startX + hotbarSlot * 18, startY + 54 + 4));
        }
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex, int blockContainerSize) {
        ItemStack itemstack = ItemStack.f_41583_;
        if (blockContainerSize <= 0 || !this.hasPlayerSlots()) {
            return itemstack;
        }
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex < blockContainerSize ? !this.m_38903_(itemstack1, blockContainerSize, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, blockContainerSize, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void setController(Level level, BlockPos pos, ControllerBlockEntity blockEntity) {
        this.controllerPos = pos;
        this.controller = blockEntity;
    }

    @Override
    public void clearController() {
        this.controllerPos = null;
        this.controller = null;
    }

    @Override
    public Optional<ControllerBlockEntity> getController() {
        return Optional.ofNullable(this.controller);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }
}

