/*
 * Decompiled with CFR 0.152.
 */
package axolootl.menu;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.block.entity.AxolootlInspectorBlockEntity;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.item.AxolootlBucketItem;
import axolootl.menu.CyclingContainerMenu;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AxolootlInspectorMenu
extends CyclingContainerMenu {
    public static final int INV_X = 79;
    public static final int INV_Y = 19;
    private AxolootlInspectorBlockEntity blockEntity;
    private ContainerData data;
    private boolean isChanged;

    public AxolootlInspectorMenu(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle) {
        super((MenuType)AxRegistry.MenuReg.INSPECTOR.get(), windowId, inv, controllerPos, controller, blockPos, tab, cycle, controller.getTrackedBlocks(AxRegistry.AquariumTabsReg.AXOLOOTL_INSPECTOR.getId()));
    }

    @Override
    protected void addBlockSlots(BlockPos blockPos) {
        this.data = new SimpleContainerData(2);
        BlockEntity blockEntity = this.controller.m_58904_().m_7702_(blockPos);
        if (!(blockEntity instanceof AxolootlInspectorBlockEntity)) {
            return;
        }
        AxolootlInspectorBlockEntity blockEntity2 = (AxolootlInspectorBlockEntity)blockEntity;
        this.blockEntity = blockEntity2;
        this.container = blockEntity2;
        this.containerSize = this.container.m_6643_();
        this.containerRows = 1;
        this.data = blockEntity2.getDataAccess();
        this.m_38884_(this.data);
        this.m_38897_(new AxolootlSlot(this.container, 0, 79, 19));
        this.m_38897_(new ResultSlot(this.container, 1, 127, 19, this::setChanged));
    }

    @Nullable
    public AxolootlInspectorBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean hasProgress() {
        return this.data.m_6413_(0) > 0;
    }

    public float getProgress() {
        return (float)this.data.m_6413_(0) / (float)Math.max(1, this.data.m_6413_(1));
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean changed) {
        this.isChanged = changed;
    }

    protected static class AxolootlSlot
    extends Slot {
        public AxolootlSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack pStack) {
            return pStack.m_41782_() && pStack.m_41783_().m_128425_("Axolootl", 8);
        }
    }

    protected static class ResultSlot
    extends Slot {
        private final Consumer<Boolean> setChanged;

        public ResultSlot(Container pContainer, int pSlot, int pX, int pY, Consumer<Boolean> setChanged) {
            super(pContainer, pSlot, pX, pY);
            this.setChanged = setChanged;
        }

        public void m_142406_(Player pPlayer, ItemStack pStack) {
            Optional<AxolootlVariant> oVariant = AxolootlBucketItem.getVariant(pPlayer.f_19853_.m_8891_(), pStack);
            if (oVariant.isPresent()) {
                this.addAxolootlResearch(pPlayer, oVariant.get().getRegistryName(pPlayer.f_19853_.m_8891_()));
            }
            super.m_142406_(pPlayer, pStack);
        }

        public boolean m_5857_(ItemStack pStack) {
            return false;
        }

        protected void addAxolootlResearch(Player player, ResourceLocation id) {
            player.getCapability(Axolootl.AXOLOOTL_RESEARCH_CAPABILITY).ifPresent(c -> {
                if (c.addAxolootl(id) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    player.m_216990_(SoundEvents.f_12275_);
                    c.syncToClient(serverPlayer);
                }
            });
            this.setChanged.accept(true);
        }
    }
}

