/*
 * Decompiled with CFR 0.152.
 */
package axolootl.menu;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.menu.AbstractControllerMenu;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class CyclingContainerMenu
extends AbstractControllerMenu {
    public static final int INV_X = 30;
    public static final int INV_Y = 18;
    public final int cycleCount;
    protected final List<BlockPos> sortedCycleList;
    protected int containerRows;
    protected int containerSize;
    protected Container container;

    public CyclingContainerMenu(MenuType<?> menuType, int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle, Collection<BlockPos> positions) {
        super(menuType, windowId, inv, controllerPos, controller, blockPos, tab, cycle);
        ArrayList<BlockPos> builder = new ArrayList<BlockPos>(positions);
        builder.sort(Vec3i::compareTo);
        this.sortedCycleList = ImmutableList.copyOf(builder);
        this.cycleCount = this.sortedCycleList.size();
        if (cycle < 0) {
            this.cycle = this.sortedCycleList.indexOf(blockPos);
        }
        this.addBlockSlots(blockPos);
        this.addPlayerSlots(inv, 30, 140);
    }

    public static CyclingContainerMenu createOutput(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle) {
        return new CyclingContainerMenu((MenuType)AxRegistry.MenuReg.OUTPUT.get(), windowId, inv, controllerPos, controller, blockPos, tab, cycle, controller.getResourceOutputs());
    }

    public static CyclingContainerMenu createLargeOutput(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle) {
        return new CyclingContainerMenu((MenuType)AxRegistry.MenuReg.LARGE_OUTPUT.get(), windowId, inv, controllerPos, controller, blockPos, tab, cycle, controller.getResourceOutputs());
    }

    public static CyclingContainerMenu createFeeder(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle) {
        return new CyclingContainerMenu((MenuType)AxRegistry.MenuReg.AUTOFEEDER.get(), windowId, inv, controllerPos, controller, blockPos, tab, cycle, controller.resolveModifiers(controller.m_58904_().m_8891_(), (b, a) -> ((IAquariumTab)AxRegistry.AquariumTabsReg.FOOD_INTERFACE.get()).isFor((LevelAccessor)controller.m_58904_(), (BlockPos)b, controller.m_58904_().m_8055_(b))).keySet());
    }

    public static CyclingContainerMenu createBreeder(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle) {
        return new CyclingContainerMenu((MenuType)AxRegistry.MenuReg.BREEDER.get(), windowId, inv, controllerPos, controller, blockPos, tab, cycle, controller.resolveModifiers(controller.m_58904_().m_8891_(), (b, a) -> ((IAquariumTab)AxRegistry.AquariumTabsReg.FOOD_INTERFACE.get()).isFor((LevelAccessor)controller.m_58904_(), (BlockPos)b, controller.m_58904_().m_8055_(b))).keySet());
    }

    public static CyclingContainerMenu createMonsterium(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle) {
        return new CyclingContainerMenu((MenuType)AxRegistry.MenuReg.MONSTERIUM.get(), windowId, inv, controllerPos, controller, blockPos, tab, cycle, controller.resolveModifiers(controller.m_58904_().m_8891_(), (b, a) -> ((IAquariumTab)AxRegistry.AquariumTabsReg.FOOD_INTERFACE.get()).isFor((LevelAccessor)controller.m_58904_(), (BlockPos)b, controller.m_58904_().m_8055_(b))).keySet());
    }

    public static CyclingContainerMenu createFluid(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle) {
        return new CyclingContainerMenu((MenuType)AxRegistry.MenuReg.FLUID.get(), windowId, inv, controllerPos, controller, blockPos, tab, cycle, controller.getFluidInputs()){

            @Override
            protected void addBlockSlots(BlockPos blockPos) {
                BlockEntity blockEntity = this.controller.m_58904_().m_7702_(blockPos);
                if (!(blockEntity instanceof Container)) {
                    return;
                }
                Container container = (Container)blockEntity;
                this.container = container;
                this.containerSize = container.m_6643_();
                this.containerRows = 1;
                this.m_38897_(new FluidItemSlot(container, 0, 30, 108, new Fluid[]{Fluids.f_76193_}));
            }
        };
    }

    protected void addBlockSlots(BlockPos blockPos) {
        BlockEntity blockEntity = this.controller.m_58904_().m_7702_(blockPos);
        if (!(blockEntity instanceof Container)) {
            return;
        }
        Container container = (Container)blockEntity;
        this.container = container;
        this.containerSize = container.m_6643_();
        this.containerRows = Math.min(6, Mth.m_14167_((float)((float)this.containerSize / 9.0f)));
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.containerSize; ++i) {
            x = 30 + i % 9 * 18;
            y = 18 + i / 9 * 18;
            this.m_38897_(new Slot(container, i, x, y));
        }
    }

    public int getRows() {
        return this.containerRows;
    }

    @Nullable
    public Container getContainer() {
        return this.container;
    }

    public int getContainerSize() {
        return this.containerSize;
    }

    @Override
    public boolean hasPlayerSlots() {
        return true;
    }

    @Override
    public int getCycleCount() {
        return this.cycleCount;
    }

    @Override
    public List<BlockPos> getSortedCycleList() {
        return this.sortedCycleList;
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return this.quickMoveStack(pPlayer, pIndex, this.containerSize);
    }

    public boolean m_6875_(Player pPlayer) {
        if (this.container != null) {
            return this.container.m_6542_(pPlayer);
        }
        return false;
    }

    protected static class FluidItemSlot
    extends Slot {
        private final Set<Fluid> fluids;

        public FluidItemSlot(Container pContainer, int pSlot, int pX, int pY, Fluid ... fluids) {
            super(pContainer, pSlot, pX, pY);
            this.fluids = Set.of(fluids);
        }

        public boolean m_5857_(ItemStack pStack) {
            LazyOptional oHandler = pStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (!oHandler.isPresent()) {
                return false;
            }
            IFluidHandlerItem handler = (IFluidHandlerItem)oHandler.resolve().get();
            FluidStack fluidStack = handler.getFluidInTank(0);
            return fluidStack.isEmpty() || this.fluids.contains(fluidStack.getFluid());
        }
    }
}

