/*
 * Decompiled with CFR 0.152.
 */
package axolootl.menu;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.menu.AbstractControllerMenu;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class CyclingMenu
extends AbstractControllerMenu {
    public final int cycleCount;
    private final List<BlockPos> sortedCycleList;
    private final boolean hasPlayerSlots;

    public CyclingMenu(MenuType<?> menuType, int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle, Collection<BlockPos> positions, boolean hasPlayerSlots) {
        super(menuType, windowId, inv, controllerPos, controller, blockPos, tab, cycle);
        ArrayList<BlockPos> builder = new ArrayList<BlockPos>(positions);
        builder.sort(Vec3i::compareTo);
        this.sortedCycleList = ImmutableList.copyOf(builder);
        this.cycleCount = this.sortedCycleList.size();
        if (cycle < 0) {
            this.cycle = this.sortedCycleList.indexOf(blockPos);
        }
        this.hasPlayerSlots = hasPlayerSlots;
        if (hasPlayerSlots) {
            this.addPlayerSlots(inv, 30, 140);
        }
    }

    public static CyclingMenu createEnergy(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity controller, BlockPos blockPos, int tab, int cycle) {
        return new CyclingMenu((MenuType)AxRegistry.MenuReg.ENERGY.get(), windowId, inv, controllerPos, controller, blockPos, tab, cycle, controller.getEnergyInputs(), true);
    }

    @Override
    public boolean hasPlayerSlots() {
        return this.hasPlayerSlots;
    }

    @Override
    public int getCycleCount() {
        return this.cycleCount;
    }

    @Override
    public List<BlockPos> getSortedCycleList() {
        return this.sortedCycleList;
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player pPlayer) {
        if (this.cycle < 0 || this.cycle >= this.getSortedCycleList().size()) {
            return false;
        }
        if (this.getController().isPresent()) {
            return true;
        }
        BlockPos pos = this.getSortedCycleList().get(this.cycle);
        return pPlayer.m_20182_().m_82509_((Position)Vec3.m_82512_((Vec3i)pos), 8.0);
    }
}

