/*
 * Decompiled with CFR 0.152.
 */
package axolootl.network;

import axolootl.Axolootl;
import axolootl.capability.AxolootlResearchCapability;
import axolootl.client.ClientUtil;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSyncAxolootlResearchCapabilityPacket {
    private static final String KEY_CAPABILITY = "Capability";
    private CompoundTag tag;

    public ClientBoundSyncAxolootlResearchCapabilityPacket(AxolootlResearchCapability capability) {
        this(capability.serializeNBT());
    }

    private ClientBoundSyncAxolootlResearchCapabilityPacket(CompoundTag tag) {
        this.tag = tag;
    }

    private ClientBoundSyncAxolootlResearchCapabilityPacket(ListTag listTag) {
        this.tag = new CompoundTag();
        this.tag.m_128365_(KEY_CAPABILITY, (Tag)listTag);
    }

    public ListTag getListTag() {
        return this.tag.m_128437_(KEY_CAPABILITY, 8);
    }

    public static ClientBoundSyncAxolootlResearchCapabilityPacket fromBytes(FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130260_();
        return new ClientBoundSyncAxolootlResearchCapabilityPacket(tag);
    }

    public static void toBytes(ClientBoundSyncAxolootlResearchCapabilityPacket msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.tag);
    }

    public static void handlePacket(ClientBoundSyncAxolootlResearchCapabilityPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Player player = ClientUtil.getClientPlayer();
                if (null == player) {
                    return;
                }
                Optional oCap = player.getCapability(Axolootl.AXOLOOTL_RESEARCH_CAPABILITY).resolve();
                oCap.ifPresent(c -> c.deserializeNBT(message.getListTag()));
            });
        }
        context.setPacketHandled(true);
    }
}

